/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gbf-build-info.h
 *
 * Copyright (C) 2001  JP Rosevear
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#ifndef _GBF_BUILD_INFO_H_
#define _GBF_BUILD_INFO_H_

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GBF_TYPE_BUILD_INFO			(gbf_build_info_get_type ())
#define GBF_BUILD_INFO(obj)			(GTK_CHECK_CAST ((obj), GBF_TYPE_BUILD_INFO, GbfBuildInfo))
#define GBF_BUILD_INFO_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GBF_TYPE_BUILD_INFO, GbfBuildInfoClass))
#define GBF_IS_BUILD_INFO(obj)			(GTK_CHECK_TYPE ((obj), GBF_TYPE_BUILD_INFO))
#define GBF_IS_BUILD_INFO_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GBF_TYPE_BUILD_INFO))

typedef struct _GbfBuildInfo        GbfBuildInfo;
typedef struct _GbfBuildInfoPrivate GbfBuildInfoPrivate;
typedef struct _GbfBuildInfoClass   GbfBuildInfoClass;

struct _GbfBuildInfo {
	GtkVBox parent;

	GbfBuildInfoPrivate *priv;
};

struct _GbfBuildInfoClass {
	GtkVBoxClass parent_class;

	void (* warning_selected) (GbfBuildInfo *info, const char *filename, int line);
	void (* error_selected) (GbfBuildInfo *info, const char *filename, int line);
};

GType      gbf_build_info_get_type (void);
GtkWidget *gbf_build_info_new      (void);

G_END_DECLS

#endif /* _GBF_BUILD_INFO_H_ */
