/* Functions for setting EWMH flags on windows.
 * Copyright (C) 2003 Martin Grimme
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>


#define _NET_WM_STATE_REMOVE        0    /* remove/unset property */
#define _NET_WM_STATE_ADD           1    /* add/set property */
#define _NET_WM_STATE_TOGGLE        2    /* toggle property  */  

#define ATOM(name) gdk_x11_get_xatom_by_name(name)



/* Adopted from gKrellm2.
 */
void _change_state (GdkNativeWindow window, gboolean add, gchar* atom,
                    gchar* state1, gchar* state2) {
  
  XEvent xev;
  
  xev.type = ClientMessage;
  xev.xclient.type = ClientMessage;
  xev.xclient.window = window;
  xev.xclient.message_type = ATOM(atom);
  xev.xclient.format = 32;
  xev.xclient.data.l[0] = add ? _NET_WM_STATE_ADD : _NET_WM_STATE_REMOVE;
  xev.xclient.data.l[1] = ATOM(state1);
  xev.xclient.data.l[2] = state2 ? state2 : 0; /* ATOM(state2); */

  XSendEvent(GDK_DISPLAY(), GDK_ROOT_WINDOW(), False,
             SubstructureNotifyMask, &xev);

}



void set_below(GdkWindow* window) {

  gdk_window_set_type_hint(window, GDK_WINDOW_TYPE_HINT_DOCK);
  _change_state(GDK_WINDOW_XID(window), FALSE, "_NET_WM_STATE",
                "_NET_WM_STATE_ABOVE", NULL);
  _change_state(GDK_WINDOW_XID(window), TRUE, "_NET_WM_STATE",
                "_NET_WM_STATE_BELOW", NULL);

}



void set_above(GdkWindow* window) {

  gdk_window_set_type_hint(window, GDK_WINDOW_TYPE_HINT_DOCK);
  _change_state(GDK_WINDOW_XID(window), FALSE, "_NET_WM_STATE",
                "_NET_WM_STATE_BELOW", NULL);
  _change_state(GDK_WINDOW_XID(window), TRUE, "_NET_WM_STATE",
                "_NET_WM_STATE_ABOVE", NULL);

}



void set_normal(GdkWindow* window) {

  _change_state(GDK_WINDOW_XID(window), FALSE, "_NET_WM_STATE",
                "_NET_WM_STATE_ABOVE", NULL);
  _change_state(GDK_WINDOW_XID(window), FALSE, "_NET_WM_STATE",
                "_NET_WM_STATE_BELOW", NULL);
  gdk_window_set_type_hint(window, GDK_WINDOW_TYPE_HINT_NORMAL);

}



void set_skip(GdkWindow* window) {

  _change_state(GDK_WINDOW_XID(window), TRUE, "_NET_WM_STATE",
                "_NET_WM_SKIP_TASKBAR", "_NET_WM_SKIP_PAGER");

}
