/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 39 "games-scores-dialog.gob"

/* Games Scores Dialog - Display high scores
 *
 * Copyright (c) 2004, 2005 by Callum McKenzie
 *
 */


#line 16 "games-scores-dialog.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "games-scores-dialog.h"

#include "games-scores-dialog-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 48 "games-scores-dialog.gob"

#include <glib/gi18n.h>
#include <gtk/gtk.h>

#line 42 "games-scores-dialog.c"

#line 53 "games-scores-dialog.gob"


#include <config.h>

#include <gnome.h>

#include <math.h>

#line 53 "games-scores-dialog.c"
/* self casting macros */
#define SELF(x) GAMES_SCORES_DIALOG(x)
#define SELF_CONST(x) GAMES_SCORES_DIALOG_CONST(x)
#define IS_SELF(x) GAMES_IS_SCORES_DIALOG(x)
#define TYPE_SELF GAMES_TYPE_SCORES_DIALOG
#define SELF_CLASS(x) GAMES_SCORES_DIALOG_CLASS(x)

#define SELF_GET_CLASS(x) GAMES_SCORES_DIALOG_GET_CLASS(x)

/* self typedefs */
typedef GamesScoresDialog Self;
typedef GamesScoresDialogClass SelfClass;

/* here are local prototypes */
static void games_scores_dialog_class_init (GamesScoresDialogClass * c) G_GNUC_UNUSED;
static void games_scores_dialog_load_categories (GamesScoresCategory * cat, GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_name_edited (GtkCellRendererText * cell, gchar * path, gchar * new_text, GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_cursor_changed (GtkTreeView * treeview, GamesScoresDialog * self) G_GNUC_UNUSED;
static gboolean games_scores_dialog_set_edit (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_set_hilight_private (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_redraw (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_change_category (GtkComboBox * widget, GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_show (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_hide (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_init (GamesScoresDialog * self) G_GNUC_UNUSED;
static void games_scores_dialog_add_category (GamesScoresDialog * self, const gchar * key, const gchar * name) G_GNUC_UNUSED;
static void games_scores_dialog_set_category (GamesScoresDialog * self, const gchar * key) G_GNUC_UNUSED;
static void games_scores_dialog_set_style (GamesScoresDialog * self, GamesScoreStyle style) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkDialogClass *parent_class = NULL;

/* Short form macros */
#define self_load_categories games_scores_dialog_load_categories
#define self_new games_scores_dialog_new
#define self_name_edited games_scores_dialog_name_edited
#define self_cursor_changed games_scores_dialog_cursor_changed
#define self_set_edit games_scores_dialog_set_edit
#define self_set_hilight_private games_scores_dialog_set_hilight_private
#define self_redraw games_scores_dialog_redraw
#define self_change_category games_scores_dialog_change_category
#define self_show games_scores_dialog_show
#define self_hide games_scores_dialog_hide
#define self_add_category games_scores_dialog_add_category
#define self_set_category games_scores_dialog_set_category
#define self_set_style games_scores_dialog_set_style
#define self_set_category_description games_scores_dialog_set_category_description
#define self_set_hilight games_scores_dialog_set_hilight
#define self_set_message games_scores_dialog_set_message
#define self_set_buttons games_scores_dialog_set_buttons
GType
games_scores_dialog_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GamesScoresDialogClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) games_scores_dialog_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GamesScoresDialog),
			0 /* n_preallocs */,
			(GInstanceInitFunc) games_scores_dialog_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_DIALOG, "GamesScoresDialog", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GamesScoresDialog *)g_object_new(games_scores_dialog_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GamesScoresDialog * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GamesScoresDialog *
GET_NEW_VARG (const char *first, ...)
{
	GamesScoresDialog *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GamesScoresDialog *)g_object_new_valist (games_scores_dialog_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::finalize"
	GamesScoresDialog *self G_GNUC_UNUSED = GAMES_SCORES_DIALOG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 76 "games-scores-dialog.gob"
	if(self->_priv->scores) { g_object_unref ((gpointer) self->_priv->scores); self->_priv->scores = NULL; }
#line 157 "games-scores-dialog.c"
#line 77 "games-scores-dialog.gob"
	if(self->_priv->categories) { g_hash_table_destroy ((gpointer) self->_priv->categories); self->_priv->categories = NULL; }
#line 160 "games-scores-dialog.c"
#line 78 "games-scores-dialog.gob"
	if(self->_priv->catindices) { g_hash_table_destroy ((gpointer) self->_priv->catindices); self->_priv->catindices = NULL; }
#line 163 "games-scores-dialog.c"
}
#undef __GOB_FUNCTION__

static void 
games_scores_dialog_class_init (GamesScoresDialogClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GamesScoresDialogPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_DIALOG);

	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__
#line 271 "games-scores-dialog.gob"
static void 
games_scores_dialog_init (GamesScoresDialog * self G_GNUC_UNUSED)
#line 183 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,GAMES_TYPE_SCORES_DIALOG,GamesScoresDialogPrivate);
 {
#line 271 "games-scores-dialog.gob"

    GtkWidget *vbox;
    GtkWidget *scroll;
    GtkWidget *listview;
    GtkTreeViewColumn *column;
    GtkCellRenderer *renderer;

    self->_priv->style = GAMES_SCORES_STYLE_PLAIN_DESCENDING;
    /* These two hashes are the reverse of each other. As an optimisation 
     * they share the same set of strings (as keys in the first case and
     * as data in the second). The first hash is responsible for 
     * deallocating the memory for the strings. These two are only
     * valid as a pair. */
    self->_priv->categories = g_hash_table_new_full (g_str_hash, g_str_equal,
						     g_free, NULL);
    self->_priv->catindices = g_hash_table_new (g_direct_hash, g_direct_equal);
    self->_priv->catcounter = 0;
    self->_priv->hilight = 0;

    gtk_dialog_set_has_separator (GTK_DIALOG (self), FALSE);
    gtk_container_set_border_width (GTK_CONTAINER (self), 5);
    gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (self)->vbox), 2);

    g_signal_connect (G_OBJECT (self), "show", 
		      G_CALLBACK (games_scores_dialog_show), NULL);
    g_signal_connect (G_OBJECT (self), "hide", 
		      G_CALLBACK (games_scores_dialog_hide), NULL);

    vbox = gtk_vbox_new (FALSE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
    gtk_box_pack_end (GTK_BOX (GTK_DIALOG (self)->vbox), vbox, TRUE, TRUE, 
                      0);

    scroll = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
    gtk_widget_set_size_request (scroll, 250, 265);
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scroll),
					 GTK_SHADOW_ETCHED_IN);
    gtk_box_pack_end (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
    
    self->_priv->message = gtk_label_new ("");
    gtk_label_set_use_markup (GTK_LABEL (self->_priv->message), TRUE);
    gtk_label_set_justify (GTK_LABEL (self->_priv->message), 
	                   GTK_JUSTIFY_CENTER);    
    gtk_box_pack_start (GTK_BOX (vbox), self->_priv->message, FALSE, FALSE, 0);

    self->_priv->hdiv = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), self->_priv->hdiv, FALSE, FALSE, 0);

    self->_priv->catbar = gtk_hbox_new (FALSE, 12);
    gtk_box_pack_start (GTK_BOX (vbox), self->_priv->catbar, FALSE, FALSE, 0);

    self->_priv->label = gtk_label_new ("");
    gtk_box_pack_start (GTK_BOX (self->_priv->catbar), self->_priv->label, 
			FALSE, FALSE, 0);	
   
    self->_priv->combo = gtk_combo_box_new_text ();
    gtk_box_pack_start (GTK_BOX (self->_priv->catbar), 
			self->_priv->combo, TRUE, TRUE, 0);

    g_signal_connect (G_OBJECT (self->_priv->combo), "changed", 
		      G_CALLBACK (games_scores_dialog_change_category), self);

    self->_priv->list = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);

    listview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (self->_priv->list));
    self->_priv->treeview = GTK_TREE_VIEW (listview);
    self->_priv->cursor_handler_id = 
      g_signal_connect (G_OBJECT (self->_priv->treeview), 
			"cursor-changed", 
			G_CALLBACK (games_scores_dialog_cursor_changed), self);
    
    self->_priv->namerenderer = gtk_cell_renderer_text_new ();
    g_signal_connect (self->_priv->namerenderer, "edited", 
		      G_CALLBACK (games_scores_dialog_name_edited), self);

    self->_priv->namecolumn = gtk_tree_view_column_new_with_attributes (_("Name"),
									self->_priv->namerenderer,
									"text", 0,
									NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (listview),
				 GTK_TREE_VIEW_COLUMN (self->_priv->namecolumn));
    renderer = gtk_cell_renderer_text_new ();
    /* Note that this assumes the default style is plain. */
    column = gtk_tree_view_column_new_with_attributes (_("Score"),
						       renderer,
						       "text", 1,
						       NULL);
    g_object_set (G_OBJECT (renderer), "xalign", 1.0, NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (listview),
				 GTK_TREE_VIEW_COLUMN (column));
    self->_priv->column = column;
   
    gtk_container_add (GTK_CONTAINER (scroll), listview);
    
    games_scores_dialog_set_buttons (self, GAMES_SCORES_CLOSE_BUTTON);

    gtk_window_set_destroy_with_parent (GTK_WINDOW (self), TRUE);

    gtk_widget_show_all (vbox);
    gtk_widget_hide (self->_priv->hdiv);
    gtk_widget_hide (self->_priv->message);
  
#line 294 "games-scores-dialog.c"
 }
}
#undef __GOB_FUNCTION__


#line 87 "games-scores-dialog.gob"
static void 
games_scores_dialog_load_categories (GamesScoresCategory * cat, GamesScoresDialog * self)
#line 303 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::load_categories"
{
#line 88 "games-scores-dialog.gob"
	
    /* Note the Q_ here, this is so we can use context tags on similar
     * names. (Medium is one that can cause trouble for translators 
     * in different contexts.) */
    games_scores_dialog_add_category (self, cat->key, Q_(cat->name));
  }}
#line 314 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

/**
 * games_scores_dialog_new:
 * @domain: the scores domain to use, usually the application name
 * @title: the title for the dialog
 *
 * Creates a new high scores dialog. Use gtk_dialog_run and 
 * gtk_widget_destroy to manage it.
 *
 * Returns: a new widget
 *
 **/
#line 106 "games-scores-dialog.gob"
GtkWidget * 
games_scores_dialog_new (GamesScores * scores, const gchar * title)
#line 331 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::new"
{
#line 106 "games-scores-dialog.gob"
	
    GamesScoresDialog *dialog = GET_NEW;

    dialog->_priv->scores = g_object_ref (scores);
    games_scores_dialog_set_style (dialog, games_scores_get_style (scores));
    dialog->_priv->preservehilight = FALSE;

    gtk_window_set_title (GTK_WINDOW (dialog), title);

    games_scores_category_foreach (scores, 
				   (GamesScoresCategoryForeachFunc) games_scores_dialog_load_categories, dialog);

    if (dialog->_priv->catcounter <= 1) {
      gtk_widget_hide (dialog->_priv->catbar);
    }

    return (GtkWidget *)dialog;
  }}
#line 354 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 125 "games-scores-dialog.gob"
static void 
games_scores_dialog_name_edited (GtkCellRendererText * cell, gchar * path, gchar * new_text, GamesScoresDialog * self)
#line 360 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::name_edited"
{
#line 128 "games-scores-dialog.gob"
	
    GtkTreeIter iter;

    gtk_tree_model_get_iter_from_string (GTK_TREE_MODEL (self->_priv->list), 
					 &iter, path);
    gtk_list_store_set (self->_priv->list, &iter, 0, new_text, -1);

    games_scores_update_score (self->_priv->scores, new_text);
  }}
#line 374 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 139 "games-scores-dialog.gob"
static void 
games_scores_dialog_cursor_changed (GtkTreeView * treeview, GamesScoresDialog * self)
#line 380 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::cursor_changed"
{
#line 141 "games-scores-dialog.gob"
	
    g_object_set (self->_priv->namerenderer, "editable", FALSE, NULL);
  }}
#line 388 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 145 "games-scores-dialog.gob"
static gboolean 
games_scores_dialog_set_edit (GamesScoresDialog * self)
#line 394 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_edit"
{
#line 146 "games-scores-dialog.gob"
	
    GtkTreePath *path;
    GtkTreeSelection *selection;

    /* Just in case we've been closed as soon as we're created. */
    if (!GTK_WIDGET_REALIZED (self))
      return FALSE;

    /* Temporarily disable the code that prevents editing when the
     * cursor changes position. */
    g_signal_handler_block (self->_priv->treeview, 
			    self->_priv->cursor_handler_id); 
    g_object_set (self->_priv->namerenderer, "editable", TRUE, NULL);
    selection = gtk_tree_view_get_selection (self->_priv->treeview);
    path = gtk_tree_path_new_from_indices (self->_priv->hilight - 1, -1);
    gtk_tree_selection_select_path (selection, path);
    gtk_tree_view_set_cursor (self->_priv->treeview, path, 
			      self->_priv->namecolumn, TRUE);
    g_signal_handler_unblock (self->_priv->treeview, 
			      self->_priv->cursor_handler_id); 
    g_free (path);

    return FALSE;
  }}
#line 423 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 171 "games-scores-dialog.gob"
static void 
games_scores_dialog_set_hilight_private (GamesScoresDialog * self)
#line 429 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_hilight_private"
{
#line 172 "games-scores-dialog.gob"
	

    if (self->_priv->hilight == 0) {
      g_object_set (self->_priv->namerenderer, "editable", FALSE, NULL);
      return;
    }
    
    /* We can't set the hilight editable immediately in case we are
     * still in the process of being created and the editing subwindow
     * gets put in the wrong place. Attaching to the expose signal
     * doesn't seem to have the desired effect, so instead we just
     * wait until all other work is done. */
    g_idle_add ((GSourceFunc)games_scores_dialog_set_edit, self);
  }}
#line 448 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 187 "games-scores-dialog.gob"
static void 
games_scores_dialog_redraw (GamesScoresDialog * self)
#line 454 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::redraw"
{
#line 188 "games-scores-dialog.gob"
	
    GtkTreeIter iter;
    gchar *name;
    gint score;
    gchar *ss;
    gdouble dscore;
    GList *scorelist;

    gtk_list_store_clear (self->_priv->list);

    scorelist = games_scores_get (self->_priv->scores);

    while (scorelist) {
      name = ((GamesScore *)scorelist->data)->name;
      switch (self->_priv->style) {
      case GAMES_SCORES_STYLE_TIME_ASCENDING:
      case GAMES_SCORES_STYLE_TIME_DESCENDING:
	dscore = ((GamesScore *)scorelist->data)->value.time_double;
	score = rint (100*(dscore));
	/* Translators: this is for a minutes, seconds time display. */
	ss = g_strdup_printf (_("%dm %ds"), score/100, score%100);
	break; 
      case GAMES_SCORES_STYLE_PLAIN_ASCENDING:
      case GAMES_SCORES_STYLE_PLAIN_DESCENDING:
      default:
	score = ((GamesScore *)scorelist->data)->value.plain;
	ss = g_strdup_printf ("%d", score);
      }
      gtk_list_store_append (self->_priv->list, &iter);
      gtk_list_store_set (self->_priv->list, &iter, 0, name, 1, ss, -1);
      g_free (ss);
      scorelist = g_list_next (scorelist);
    }
      
    games_scores_dialog_set_hilight_private (self);
  }}
#line 495 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 225 "games-scores-dialog.gob"
static void 
games_scores_dialog_change_category (GtkComboBox * widget, GamesScoresDialog * self)
#line 501 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::change_category"
{
#line 226 "games-scores-dialog.gob"
	
    gchar *catcopy;
    gint idx;
    gchar *newcat;
    
    /* This seems like a bit of a hack, but since we're trying to
     * temporarily change the category it sort of makes sense. */

    catcopy = g_strdup (games_scores_get_category (self->_priv->scores));
    idx = gtk_combo_box_get_active (widget);
    newcat = g_hash_table_lookup (self->_priv->catindices,
				 GINT_TO_POINTER (idx));

    games_scores_set_category (self->_priv->scores, newcat);
    if (self->_priv->preservehilight) {
      self->_priv->preservehilight = FALSE;
    } else {
      self->_priv->hilight = 0;
    }
    games_scores_dialog_redraw (self);
    games_scores_set_category (self->_priv->scores, catcopy);

    g_free (catcopy);
  }}
#line 530 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 255 "games-scores-dialog.gob"
static void 
games_scores_dialog_show (GamesScoresDialog * self)
#line 536 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::show"
{
#line 256 "games-scores-dialog.gob"
	 
    const gchar *cat;
    
    cat = games_scores_get_category (self->_priv->scores);
    if (cat)
      games_scores_dialog_set_category (self, cat);
    games_scores_dialog_redraw (self);
  }}
#line 549 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 265 "games-scores-dialog.gob"
static void 
games_scores_dialog_hide (GamesScoresDialog * self)
#line 555 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::hide"
{
#line 266 "games-scores-dialog.gob"
	
    self->_priv->hilight = 0;
    gtk_tree_selection_unselect_all (gtk_tree_view_get_selection (self->_priv->treeview));
  }}
#line 564 "games-scores-dialog.c"
#undef __GOB_FUNCTION__


/**
 * games_scores_dialog_add_category:
 * @self: a pointer to a GamesScoresDialog
 * @key: an identifier for the category. This should also be a valid
 * score category for the gnome_score system.
 * @name: the category name
 *
 * Adds a new category to combo box selector.
 *
 **/
#line 387 "games-scores-dialog.gob"
static void 
games_scores_dialog_add_category (GamesScoresDialog * self, const gchar * key, const gchar * name)
#line 581 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::add_category"
{
#line 389 "games-scores-dialog.gob"
	
    gchar *k;

    k = g_strdup (key);

    g_hash_table_insert (self->_priv->categories, k, 
			 GINT_TO_POINTER (self->_priv->catcounter));
    g_hash_table_insert (self->_priv->catindices, 
			 GINT_TO_POINTER (self->_priv->catcounter),
			 k);
    self->_priv->catcounter++;
    gtk_combo_box_append_text (GTK_COMBO_BOX (self->_priv->combo), name);
  }}
#line 599 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

/**
 * games_scores_dialog_set_category:
 * @self: a pointer to a GamesScoresDialog
 * @key: the category to change to
 *
 * Sets the category to scores dialog is displaying.
 *
 **/
#line 411 "games-scores-dialog.gob"
static void 
games_scores_dialog_set_category (GamesScoresDialog * self, const gchar * key)
#line 613 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_category"
{
#line 411 "games-scores-dialog.gob"
	
    gint idx;

    idx = GPOINTER_TO_SIZE (g_hash_table_lookup (self->_priv->categories, 
						key));
    self->_priv->preservehilight = TRUE;
    gtk_combo_box_set_active (GTK_COMBO_BOX (self->_priv->combo), idx);
  }}
#line 626 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

/**
 * games_scores_dialog_set_style:
 * @self: a pointer to a GamesScoresDialog
 * @style: the style to use
 *
 * Sets the style of score displayed. e.g. GAMES_SCORES_STYLE_TIME
 * displays the scores as times. Note that the order of the scores
 * is determined at the gnome_score layer but their interpretation
 * is at this layer.
 *
 **/
#line 431 "games-scores-dialog.gob"
static void 
games_scores_dialog_set_style (GamesScoresDialog * self, GamesScoreStyle style)
#line 643 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_style"
{
#line 431 "games-scores-dialog.gob"
	
    gchar *header;

    self->_priv->style = style;
    switch (style) {
    case GAMES_SCORES_STYLE_TIME_DESCENDING:
    case GAMES_SCORES_STYLE_TIME_ASCENDING:
      header = _("Time");
      break;
    case GAMES_SCORES_STYLE_PLAIN_DESCENDING:
    case GAMES_SCORES_STYLE_PLAIN_ASCENDING:
    default:
      header = _("Score");
    }

    gtk_tree_view_column_set_title (self->_priv->column, header);
  }}
#line 665 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

/**
 * games_scores_dialog_set_category_description:
 * @self: a pointer to a GamesScoresDialog
 * @pos: the position in the high score list to hilight. Should be in the
 * range 1 to 10.
 *
 * Hilights an entry in the high score list. This is suitable for indicating
 * to the player where the game they just played is.
 *
 **/
#line 458 "games-scores-dialog.gob"
void 
games_scores_dialog_set_category_description (GamesScoresDialog * self, const gchar * description)
#line 681 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_category_description"
{
#line 459 "games-scores-dialog.gob"
	
    gchar *lstr;

    lstr = g_strdup_printf ("<b>%s</b>", description);
    gtk_label_set_text (GTK_LABEL (self->_priv->label), lstr);
    gtk_label_set_use_markup (GTK_LABEL (self->_priv->label), TRUE);
    g_free(lstr);
  }}
#line 694 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

#line 478 "games-scores-dialog.gob"
void 
games_scores_dialog_set_hilight (GamesScoresDialog * self, guint pos)
#line 700 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_hilight"
{
#line 479 "games-scores-dialog.gob"
	
    if ((pos < 1) || (pos > GAMES_SCORES_SIGNIFICANT))
      return;

    self->_priv->hilight = pos;
    games_scores_dialog_set_hilight_private (self);
  }}
#line 712 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

/**
 * games_scores_dialog_set_message:
 * @self: a pointer to a GamesScoresDialog
 * @message: the message
 *
 * Sets the message at the top of the dialog. Pango markup is understood.
 *
 **/
#line 495 "games-scores-dialog.gob"
void 
games_scores_dialog_set_message (GamesScoresDialog * self, const gchar * message)
#line 726 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_message"
{
#line 495 "games-scores-dialog.gob"
	
    if ((message == NULL) || (*message == '\0')) {
      gtk_widget_hide (self->_priv->message);
      gtk_widget_hide (self->_priv->hdiv);
    } else {
      gtk_widget_show (self->_priv->message);
      gtk_widget_show (self->_priv->hdiv);
      gtk_label_set_label (GTK_LABEL (self->_priv->message), message);
    }
  }}
#line 741 "games-scores-dialog.c"
#undef __GOB_FUNCTION__

/**
 * games_scores_dialog_set_buttons:
 * @self: a pointer to a GamesScoresDialog
 * @buttons: An or-ed list of GamesScoresButtons
 *
 * Changes the button sets at the buttom of the dialog
 *
 **/
#line 514 "games-scores-dialog.gob"
void 
games_scores_dialog_set_buttons (GamesScoresDialog * self, guint buttons)
#line 755 "games-scores-dialog.c"
{
#define __GOB_FUNCTION__ "Games:Scores:Dialog::set_buttons"
{
#line 514 "games-scores-dialog.gob"
	
    /* Remove an existing buttons. */
    gtk_container_foreach (GTK_CONTAINER (GTK_DIALOG (self)->action_area),
                           (GtkCallback) (gtk_widget_destroy), NULL);

    /* The default is a single close button, suitable for the scores
       menu item. */
    if (buttons == 0)
	buttons = GAMES_SCORES_CLOSE_BUTTON;

    if (buttons & GAMES_SCORES_QUIT_BUTTON) {
	gtk_dialog_add_button (GTK_DIALOG (self), GTK_STOCK_QUIT,
	                       GTK_RESPONSE_REJECT);
        gtk_dialog_set_default_response (GTK_DIALOG (self), 
	       			         GTK_RESPONSE_REJECT);
    }

    if (buttons & GAMES_SCORES_UNDO_BUTTON) {
	gtk_dialog_add_button (GTK_DIALOG (self), GTK_STOCK_UNDO,
	                       GTK_RESPONSE_DELETE_EVENT);
        gtk_dialog_set_default_response (GTK_DIALOG (self), 
	       			         GTK_RESPONSE_DELETE_EVENT);
    }

    if (buttons & GAMES_SCORES_NEW_GAME_BUTTON) {
	gtk_dialog_add_button (GTK_DIALOG (self), _("New Game"),
	                       GTK_RESPONSE_ACCEPT);
        gtk_dialog_set_default_response (GTK_DIALOG (self), 
	       			         GTK_RESPONSE_ACCEPT);
    }

    if (buttons & GAMES_SCORES_CLOSE_BUTTON) {
	gtk_dialog_add_button (GTK_DIALOG (self), GTK_STOCK_CLOSE,
	                       GTK_RESPONSE_CLOSE);
        gtk_dialog_set_default_response (GTK_DIALOG (self), 
	       			         GTK_RESPONSE_CLOSE);
    }
  }}
#line 798 "games-scores-dialog.c"
#undef __GOB_FUNCTION__
