/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.GObject;
/**
 * The PangoFontFace structure is used to represent a group of fonts with the
 * same family, slant, weight, width, but varying sizes. 
 */
public class FontFace extends GObject 
{

	/**
	 * Gets a name representing the style of this face among the different faces
	 * in the PangoFontFamily for the face. This name is unique among all faces
	 * in the family and is suitable for displaying to users.
	 */
	public String toString(){
		return pango_font_face_get_face_name(getHandle());
	}

	/**
	 * Returns the family, style, variant, weight and stretch of a
	 * PangoFontFace. The size field of the resulting font description will be
	 * unset.
	 */
	public FontDescription describe(){
		return new FontDescription( pango_font_face_describe(getHandle()) );
	}


	/****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int pango_font_face_get_type ();
    native static final protected int pango_font_face_describe (int face);
    native static final protected String pango_font_face_get_face_name (int face);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

