/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;

public class BundlePoolFilteredListener
extends DirectoryChangeListener {
    private DirectoryChangeListener delegate;
    private Set<File> bundlePoolFiles = new HashSet<File>();

    public BundlePoolFilteredListener(DirectoryChangeListener listener) {
        this.delegate = listener;
        IFileArtifactRepository bundlePool = Activator.getBundlePoolRepository();
        if (bundlePool != null) {
            IQueryResult keys = bundlePool.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
            for (IArtifactKey key : keys) {
                File artifactFile = bundlePool.getArtifactFile(key);
                if (artifactFile == null) continue;
                this.bundlePoolFiles.add(artifactFile);
            }
        }
    }

    public boolean added(File file) {
        return this.delegate.added(file);
    }

    public boolean changed(File file) {
        return this.delegate.changed(file);
    }

    public Long getSeenFile(File file) {
        return this.delegate.getSeenFile(file);
    }

    public boolean isInterested(File file) {
        if (this.bundlePoolFiles.contains(file)) {
            return false;
        }
        return this.delegate.isInterested(file);
    }

    public boolean removed(File file) {
        return this.delegate.removed(file);
    }

    public void startPoll() {
        this.delegate.startPoll();
    }

    public void stopPoll() {
        this.delegate.stopPoll();
    }
}

