/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt.GanttPlugin;
import org.xmind.ui.gantt2.viewer.GanttViewer;

public class ChangeViewerModeAction
extends Action {
    public static final String PreferenceStore_viewerMode = "org.xmind.ui.gantt.radioState.viewerMode";
    public static final String PreferenceStore_viewerMode_allTopics = "allTopics";
    public static final String PreferenceStore_viewerMode_hierarchical = "hierarchical";
    public static final String PreferenceStore_viewerMode_flat = "flat";
    public static final String ALL_TOPICS_ACTION_ID = "org.xmind.ui.gantt.action.viewerMode.allTopics";
    public static final String HIERARCHICAL_ACTION_ID = "org.xmind.ui.gantt.action.viewerMode.hierarchical";
    public static final String FLAT_ACTION_ID = "org.xmind.ui.gantt.action.viewerMode.flat";
    private GanttViewer ganttViewer;
    private ToolBarManager toolBarManager;
    private ViewerModeMenuCreator menuCreator;

    public ChangeViewerModeAction(GanttViewer ganttViewer, ToolBarManager toolBarManager) {
        super(null, 4);
        this.setId("org.xmind.ui.gantt.action.changeViewerMode");
        this.ganttViewer = ganttViewer;
        this.toolBarManager = toolBarManager;
        this.setInitialTooltip();
        this.menuCreator = new ViewerModeMenuCreator();
        this.setMenuCreator(this.menuCreator);
    }

    public void run() {
        this.showDropDownMenu();
    }

    private void showDropDownMenu() {
        ToolBar toolbar = this.toolBarManager.getControl();
        Menu m = this.menuCreator.getMenu((Control)toolbar);
        if (m != null) {
            Rectangle itemBounds = toolbar.getItem(0).getBounds();
            Point point = toolbar.toDisplay(new Point(itemBounds.x, itemBounds.y + itemBounds.height));
            m.setLocation(point.x, point.y);
            m.setVisible(true);
        }
    }

    private void switched(String newViewerMode) {
        if (this.isValidState(newViewerMode)) {
            this.updateState(newViewerMode);
            this.changeTooltip(newViewerMode);
            this.changeItemsChecked(newViewerMode);
            this.refresh();
        }
    }

    private boolean isValidState(String viewerMode) {
        return PreferenceStore_viewerMode_allTopics.equals(viewerMode) || PreferenceStore_viewerMode_hierarchical.equals(viewerMode) || PreferenceStore_viewerMode_flat.equals(viewerMode);
    }

    private void updateState(String newViewerMode) {
        GanttPlugin.getDefault().getPreferenceStore().putValue(PreferenceStore_viewerMode, newViewerMode);
    }

    private void changeTooltip(String viewerMode) {
        if (PreferenceStore_viewerMode_allTopics.equals(viewerMode)) {
            this.setText(GanttMessages.GanttView_AllTopics_text);
        } else if (PreferenceStore_viewerMode_hierarchical.equals(viewerMode)) {
            this.setText(GanttMessages.GanttView_TasksOnly_text);
        } else {
            this.setText(GanttMessages.GanttView_TasksOnlyFlat_text);
        }
    }

    private void changeItemsChecked(String viewerMode) {
        if (this.menuCreator != null && this.menuCreator.allTopicsAction != null) {
            this.menuCreator.allTopicsAction.setChecked(PreferenceStore_viewerMode_allTopics.equals(viewerMode));
            this.menuCreator.hierarchicalAction.setChecked(PreferenceStore_viewerMode_hierarchical.equals(viewerMode));
            this.menuCreator.flatAction.setChecked(PreferenceStore_viewerMode_flat.equals(viewerMode));
        }
    }

    private void refresh() {
        if (this.ganttViewer != null && this.ganttViewer.getTaskTreeViewer() != null && this.ganttViewer.getTaskBarViewer() != null) {
            this.ganttViewer.getTaskTreeViewer().update();
            this.ganttViewer.getTaskBarViewer().update();
        }
    }

    private String getViewerMode() {
        String viewerMode = GanttPlugin.getDefault().getPreferenceStore().getString(PreferenceStore_viewerMode);
        return viewerMode == null || "".equals(viewerMode) ? PreferenceStore_viewerMode_allTopics : viewerMode;
    }

    private void setInitialTooltip() {
        String viewerMode = this.getViewerMode();
        if (PreferenceStore_viewerMode_allTopics.equals(viewerMode)) {
            this.setText(GanttMessages.GanttView_AllTopics_text);
        } else if (PreferenceStore_viewerMode_hierarchical.equals(viewerMode)) {
            this.setText(GanttMessages.GanttView_TasksOnly_text);
        } else {
            this.setText(GanttMessages.GanttView_TasksOnlyFlat_text);
        }
    }

    public void setText(String text) {
        super.setText(text);
        if (text != null && this.toolBarManager != null) {
            this.toolBarManager.getControl().getParent().layout(true, true);
        }
    }

    private class ViewerModeMenuCreator
    implements IMenuCreator {
        private Menu menu;
        private IAction allTopicsAction;
        private IAction hierarchicalAction;
        private IAction flatAction;

        private ViewerModeMenuCreator() {
        }

        public Menu getMenu(Control parent) {
            if (this.menu == null) {
                this.menu = new Menu(parent);
                this.fillMenu(this.menu);
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            if (this.menu == null) {
                this.menu = new Menu(parent);
                this.fillMenu(this.menu);
            }
            return this.menu;
        }

        private void fillMenu(Menu menu) {
            this.allTopicsAction = new ViewerModeRadioAction(ChangeViewerModeAction.ALL_TOPICS_ACTION_ID, GanttMessages.GanttView_AllTopics_text);
            ActionContributionItem item0 = new ActionContributionItem(this.allTopicsAction);
            item0.fill(menu, -1);
            this.hierarchicalAction = new ViewerModeRadioAction(ChangeViewerModeAction.HIERARCHICAL_ACTION_ID, GanttMessages.GanttView_TasksOnly_text);
            ActionContributionItem item1 = new ActionContributionItem(this.hierarchicalAction);
            item1.fill(menu, -1);
            this.flatAction = new ViewerModeRadioAction(ChangeViewerModeAction.FLAT_ACTION_ID, GanttMessages.GanttView_TasksOnlyFlat_text);
            ActionContributionItem item2 = new ActionContributionItem(this.flatAction);
            item2.fill(menu, -1);
            String viewerMode = ChangeViewerModeAction.this.getViewerMode();
            if (ChangeViewerModeAction.PreferenceStore_viewerMode_allTopics.equals(viewerMode)) {
                this.allTopicsAction.setChecked(true);
            } else if (ChangeViewerModeAction.PreferenceStore_viewerMode_hierarchical.equals(viewerMode)) {
                this.hierarchicalAction.setChecked(true);
            } else {
                this.flatAction.setChecked(true);
            }
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
        }
    }

    private class ViewerModeRadioAction
    extends Action {
        public ViewerModeRadioAction(String id, String text) {
            super(text, 8);
            this.setId(id);
        }

        public void run() {
            String viewerMode = ChangeViewerModeAction.this.getViewerMode();
            if (ChangeViewerModeAction.PreferenceStore_viewerMode_allTopics.equals(viewerMode) && !ChangeViewerModeAction.ALL_TOPICS_ACTION_ID.equals(this.getId()) || ChangeViewerModeAction.PreferenceStore_viewerMode_hierarchical.equals(viewerMode) && !ChangeViewerModeAction.HIERARCHICAL_ACTION_ID.equals(this.getId()) || ChangeViewerModeAction.PreferenceStore_viewerMode_flat.equals(viewerMode) && !ChangeViewerModeAction.FLAT_ACTION_ID.equals(this.getId())) {
                ChangeViewerModeAction.this.switched(this.getNewState());
            }
        }

        private String getNewState() {
            if (ChangeViewerModeAction.ALL_TOPICS_ACTION_ID.equals(this.getId())) {
                return ChangeViewerModeAction.PreferenceStore_viewerMode_allTopics;
            }
            if (ChangeViewerModeAction.HIERARCHICAL_ACTION_ID.equals(this.getId())) {
                return ChangeViewerModeAction.PreferenceStore_viewerMode_hierarchical;
            }
            return ChangeViewerModeAction.PreferenceStore_viewerMode_flat;
        }
    }
}

