/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;
import org.xmind.ui.internal.ToolkitPlugin;

public class JobPool {
    private static boolean DEBUG = false;
    private static final int DEFAULT_RETRY_NUM = 0;
    private static final int DEFAULT_RUNNING_MAX_NUM = 5;
    private Queue<JobTask> waitingJobs = new ConcurrentLinkedQueue<JobTask>();
    private int retryNum = 0;
    private int runningMaxNum = 5;
    private int runningJobCount = 0;

    public int getRetryNum() {
        return this.retryNum;
    }

    public void setRetryNum(int retryNum) {
        this.retryNum = retryNum;
    }

    public int getRunningMaxNum() {
        return this.runningMaxNum;
    }

    public void setRunningMaxNum(int runningMaxNum) {
        this.runningMaxNum = runningMaxNum;
    }

    public void scheduleJob(Job job, Runnable onFinish) {
        this.waitingJobs.offer(new JobTask(job, onFinish));
        this.scheduleNext();
    }

    public void cancelRemaining() {
        this.waitingJobs.clear();
    }

    private synchronized void scheduleNext() {
        JobTask task;
        if (this.runningJobCount < this.runningMaxNum && (task = this.waitingJobs.poll()) != null) {
            try {
                this.startJob(task.job, task.onFinish);
            }
            catch (Throwable e) {
                JobPool.log(e, "Error occurred while job running...");
            }
            ++this.runningJobCount;
        }
    }

    private void startJob(final Job job, final Runnable onFinish) {
        final int[] retryCount = new int[1];
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                int status = event.getJob().getResult().getSeverity();
                if (status != 0 && status != 8) {
                    retryCount[0] = retryCount[0] + 1;
                    if (retryCount[0] < JobPool.this.retryNum) {
                        job.schedule();
                        if (DEBUG) {
                            System.out.println("Retry failed [try=" + (retryCount[0] + 1) + "].");
                        }
                        return;
                    }
                    if (DEBUG) {
                        System.out.println(NLS.bind((String)"Job failed after {0} retries.", (Object)JobPool.this.retryNum));
                    }
                } else if (DEBUG) {
                    if (status == 0) {
                        System.out.println("Job succeeded.");
                    } else {
                        System.out.println("Job canceled.");
                    }
                }
                try {
                    if (onFinish != null) {
                        try {
                            onFinish.run();
                        }
                        catch (Throwable e) {
                            JobPool.log(e, "Error occurred while calling back on job finished.");
                        }
                    }
                }
                finally {
                    JobPool jobPool = JobPool.this;
                    jobPool.runningJobCount = jobPool.runningJobCount - 1;
                    JobPool.this.scheduleNext();
                }
            }
        });
        job.schedule();
        if (DEBUG) {
            System.out.println("New job start [try=" + (retryCount[0] + 1) + "].");
        }
    }

    public static void log(Throwable exception, String message) {
        ToolkitPlugin.getDefault().getLog().log((IStatus)new Status(exception == null ? 1 : 4, "org.xmind.ui.toolkit", message, exception));
    }

    private static class JobTask {
        final Job job;
        final Runnable onFinish;

        public JobTask(Job job, Runnable onFinish) {
            this.job = job;
            this.onFinish = onFinish;
        }
    }
}

