/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MT_CLIENT_H
#define MT_CLIENT_H

#include <glib.h>
#include <maitretarot.h>

/**
   \enum Name of the call back function used by libmt_client
 */
typedef enum
{
  LIBMT_CLIENT_FUNCTION_INIT = 0,   /**< First fonction call before everything 
				       (to set nick[0] and client needs)*/
  LIBMT_CLIENT_FUNCTION_GAME_INIT,  /**< Card are nows known*/
  LIBMT_CLIENT_FUNCTION_MAKE_BID,   /**< It's our turn to do our bid*/
  LIBMT_CLIENT_FUNCTION_MAKE_CHIEN, /**< We won the bid, we have to make the chien*/
  LIBMT_CLIENT_FUNCTION_NOT_MAKE_CHIEN,	/**< We loose the bid*/
  LIBMT_CLIENT_FUNCTION_CHOOSE_CARD,  /**< Fonction called at every turn*/
  LIBMT_CLIENT_FUNCTION_DRAW, /**< generaly called after the effect of the 
				 previous function for a gui*/
  LIBMT_CLIENT_FUNCTION_REMOVE_CARD, /**< Called when the card palyed is accepted 
					by the server and let know the result of the turn */
  LIBMT_CLIENT_FUNCTION_ACK_REPLAY, /**< Ask for replay */
  LIBMT_CLIENT_FUNCTION_LOST_CONNECTION, /**< Called when the client lose the connection with server 
					  just before the abnormal end of the main loop*/
  LIBMT_CLIENT_FUNCTION_NORMAL_CLOSE, /**< Last call after everything if the game ended normaly */
  LIBMT_CLIENT_MAX_FUNCTION /**< To know how many function are used*/
}
libmt_client_function_e;


typedef enum
{
  LIBMT_CLIENT_DRAW_OTHER_BID = 0,
  LIBMT_CLIENT_DRAW_GET_BID,
  LIBMT_CLIENT_DRAW_MAKE_CHIEN,
  LIBMT_CLIENT_DRAW_GET_CHIEN,
  LIBMT_CLIENT_DRAW_START_PLAYING,
  LIBMT_CLIENT_DRAW_OTHER_PLAY,
  LIBMT_CLIENT_DRAW_PAUSE_END_TURN,
  LIBMT_CLIENT_DRAW_PAUSE_END_GAME,
  LIBMT_CLIENT_DRAW_NONE_TAKE
}
libmt_client_draw_state_e;

/**
 * \struct libmt_client_player_t used as main arguement of client call back
 * 
 */
typedef struct
{
  libmt_net_t net; /**< Lib internnals, don't touch !*/
  libmt_channels_set_t *channels_set;	/**< Lib internals, don't touch !*/

  gint place; /**< Set after init for game_init,
	       it should be used as index in the array*/
  GString *nick[MAX_PLAYER];  /**< Name of the player,
				/!\ "our" name are written in nick[0]
				it's set by init().(before "place" is set)
			      */
  gint bid[MAX_PLAYER];	   /**< The bid of the previous player*/
  gint chien[MAX_CARD_CHIEN]; /**< State of the chien*/
  gint card[MAX_HAND_CARD];  /**< our card set just
				before the call to game_init*/
  gint card_turn[MAX_PLAYER]; /**< State of the current play*/
  gint card_previous_turn[MAX_PLAYER]; /**< Card of the previous turn*/
  gint card_play; /**<The choosed card of the turn*/

  gboolean replay; /**< TRUE if client want to replay a game, else FALSE */


  /* all the variables below are set by libmt_client_get_score */
  gint score[MAX_PLAYER]; /**< Set at the end of the game (will change in next version)*/
  libmt_bid_e contract;		/**< contract of taker  */
  gboolean taker_is_winner; 	/**< TRUE if the taker is the winner  */
  gint taker_score;		/**< taker score at the end of a game  */
  gint nb_oudler;		/**< number of oudler of taker */


  gpointer client_private_data;	/**< Private data of the client*/

  libmt_client_draw_state_e draw_state;	/**< Use to know what to draw in FUNCTION_DRAW */

  /* internal variable */
  gint nb_player;   /**< 3,4,5 players, hard coded to 4, nowadays*/
  gint nb_hand_card; /**< 18, hard coded nowadays*/
  gint nb_chien_card; /**< 6, hard coded nowadays*/
}
libmt_client_player_t;



typedef gint (*libmt_client_function_t) (libmt_client_player_t * player);


extern gboolean libmt_client_check_version (gint major, gint minor, gint micro);


extern gint libmt_client_init (libmt_client_player_t * player, gint nb_player,
			       gint nb_hand_card, gint nb_chien_card);

extern gint libmt_client_init_callback (libmt_client_function_e num_function,
					libmt_client_function_t function);

/** 
 *  \function libmt_client_main_loop
 *  \brief start the main loop of game,
 *  \param player structure where info on player are stocked
 *  \param host_name host name
 *  \param port server port
 *  \param id client identification
 *  \param version client version
 *  \return 0 in normal case, -1 if a deconnection occur
 */
extern gint libmt_client_main_loop (libmt_client_player_t * player,
				    GString * host_name, gint port, gint id,
				    gint version);

/* Server part */
extern gint libmt_client_connect_to_server (libmt_client_player_t * player,
					    GString * host_name, guint16 port,
					    gint id, gint version);

extern void libmt_client_close_connexion (libmt_client_player_t * player);

extern gint libmt_client_get_hand_card (libmt_client_player_t * player);

extern gint libmt_client_get_bid (libmt_client_player_t * player);
extern gint libmt_client_get_bid_is_valide (libmt_client_player_t * player);
extern gint libmt_client_have_to_make_bid (libmt_client_player_t * player);
extern gint libmt_client_send_bid (libmt_client_player_t * player);
extern gint libmt_client_get_final_bid (libmt_client_player_t * player);

extern gint libmt_client_get_chien (libmt_client_player_t * player);
extern gint libmt_client_send_chien (libmt_client_player_t * player);

extern gint libmt_client_is_someone_take (libmt_client_player_t * player);
extern gint libmt_client_have_to_get_chien (libmt_client_player_t * player);
extern gint libmt_client_is_the_taker (libmt_client_player_t * player);

extern gint libmt_client_get_card (libmt_client_player_t * player);
extern gint libmt_client_send_card (libmt_client_player_t * player);

extern gint libmt_client_get_last_turn (libmt_client_player_t * player);
extern gint libmt_client_get_score (libmt_client_player_t * player);
extern gint libmt_client_get_chien_at_end (libmt_client_player_t * player);

extern gint libmt_client_send_replay_answer (libmt_client_player_t * player);
extern gint libmt_client_get_replay_answer (libmt_client_player_t * player);

#endif /* MT_CLIENT_H */
