/*
 *  Authors: pbrufal (and tican)
 *
 *  Declarations for Syscriptor.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include "../include/cpu.h"
#include "../include/getopt.h"
#include "../include/help.h"
#include "../include/ide.h"
#include "../include/memory.h"
#include "../include/network.h"
#include "../include/os.h"
#include "../include/partitions.h"
#include "../include/scsi.h"
#include "../include/sound.h"
#include "../include/uptime.h"
#include "../include/version.h"
#include "../include/video.h"

int main(int argc, char **argv)
{
	int current;
	char *argument;
	const int BUF_SIZE = 100;
	const int BUF_SIZE2 = 19;
	const int BUF_SIZE3 = 10;
	const int BUF_SIZE4 = 8;
	const int BUF_SIZE5 = 8192;

	const struct option longopts[] = {
		{"all", 0, 0, 'a'},
		{"scsi", 0, 0, 'b'},
		{"cpu", 0, 0, 'c'},
		{"vga", 0, 0, 'g'},
		{"ide", 0, 0, 'i'},
		{"memory", 0, 0, 'm'},
		{"network", 0, 0, 'n'},
		{"operatingsystem", 0, 0, 'o'},
		{"partitions", 0, 0, 'p'},
		{"sound", 0, 0, 's'},
		{"uptime", 0, 0, 'u'},
		{"version", 0, 0, 'v'},
		{0, 0, 0, 0},
	};

	argument = argv[0];

	while((current = getopt_long(argc, argv, "abcghimnopsuv", longopts, NULL)) != -1) {
		switch(current) {
			case 'a':
				cpu(BUF_SIZE);
				printf("  -----\n");
				ide(BUF_SIZE2, BUF_SIZE3, BUF_SIZE4);
				printf("  -----\n");
				memory();
				printf("  -----\n");
				network(BUF_SIZE, BUF_SIZE5);
				printf("  -----\n");
				os();
				printf("  -----\n");
				partitions(BUF_SIZE);
				printf("  -----\n");
				scsi(BUF_SIZE);
				printf("  -----\n");
				sound(BUF_SIZE);
				printf("  -----\n");
				uptime();
				printf("  -----\n");
				video(BUF_SIZE);
				break;
			case 'b':
				scsi(BUF_SIZE);
				break;
			case 'c':
				cpu(BUF_SIZE);
				break;
			case 'g':
				video(BUF_SIZE);
				break;
			case 'h':
				help(argument);
				break;
			case 'i':
				ide(BUF_SIZE2, BUF_SIZE3, BUF_SIZE4);
				break;
			case 'm':
				memory();
				break;
			case 'n':
				network(BUF_SIZE, BUF_SIZE5);
				break;
			case 'o':
				os();
				break;
			case 'p':
				partitions(BUF_SIZE);
				break;
			case 's':
				sound(BUF_SIZE);
				break;
			case 'u':
				uptime();
				break;
			case 'v':
				version();
				break;
			default:
				help(argument);
				break;
		}
	}
	exit(EXIT_FAILURE);
}
