/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.sig.dss;

import gnu.crypto.sig.dss.DSSKeyPairGenerator;
import gnu.crypto.util.Prime;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.HashMap;

public class TestOfDSSKeyGeneration
implements Testlet {
    public void test(TestHarness harness) {
        harness.checkPoint("TestOfDSSKeyGeneration");
        DSSKeyPairGenerator kpg = new DSSKeyPairGenerator();
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("gnu.crypto.dss.L", new Integer(530));
        try {
            kpg.setup(map);
            harness.fail("L should be <= 1024 and of the form 512 + 64n");
        }
        catch (IllegalArgumentException x) {
            harness.check(true, "L should be <= 1024 and of the form 512 + 64n");
        }
        map.put("gnu.crypto.dss.L", new Integer(512));
        map.put("gnu.crypto.dss.use.defaults", new Boolean(false));
        kpg.setup(map);
        KeyPair kp = kpg.generate();
        BigInteger p1 = ((DSAPublicKey)kp.getPublic()).getParams().getP();
        BigInteger p2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getP();
        harness.check(p1.equals(p2), "p1.equals(p2)");
        BigInteger q1 = ((DSAPublicKey)kp.getPublic()).getParams().getQ();
        BigInteger q2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getQ();
        harness.check(q1.equals(q2), "q1.equals(q2)");
        BigInteger g1 = ((DSAPublicKey)kp.getPublic()).getParams().getG();
        BigInteger g2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getG();
        harness.check(g1.equals(g2), "g1.equals(g2)");
        harness.check(Prime.isProbablePrime((BigInteger)q1, (boolean)true), "q is probable prime");
        harness.check(Prime.isProbablePrime((BigInteger)p1, (boolean)true), "p is probable prime");
    }
}

