/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.jce;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.jce.GnuCrypto;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;

public class TestOfMessageDigest
implements Testlet {
    public void test(TestHarness harness) {
        this.setUp();
        this.testUnknownHash(harness);
        this.testEquality(harness);
        this.testCloneability(harness);
    }

    public void testUnknownHash(TestHarness harness) {
        harness.checkPoint("testUnknownHash");
        try {
            MessageDigest.getInstance("Gaudot", "GNU-CRYPTO");
            harness.fail("testUnknownHash()");
        }
        catch (Exception x) {
            harness.check(true);
        }
    }

    public void testEquality(TestHarness harness) {
        harness.checkPoint("testEquality");
        IMessageDigest gnu = null;
        MessageDigest jce = null;
        byte[] in = this.getClass().getName().getBytes();
        Iterator it = HashFactory.getNames().iterator();
        while (it.hasNext()) {
            String mdName = (String)it.next();
            try {
                gnu = HashFactory.getInstance((String)mdName);
                harness.check(gnu != null, "HashFactory.getInstance(" + mdName + ")");
            }
            catch (InternalError x) {
                harness.fail("HashFactory.getInstance(" + mdName + "): " + String.valueOf(x));
            }
            try {
                jce = MessageDigest.getInstance(mdName, "GNU-CRYPTO");
                harness.check(jce != null, "MessageDigest.getInstance()");
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("MessageDigest.getInstance(" + mdName + "): " + String.valueOf(x));
            }
            gnu.update(in, 0, in.length);
            byte[] ba1 = gnu.digest();
            byte[] ba2 = jce.digest(in);
            harness.check(Util.areEqual((byte[])ba1, (byte[])ba2), "testEquality(" + mdName + ")");
        }
    }

    public void testCloneability(TestHarness harness) {
        harness.checkPoint("testCloneability");
        byte[] abc = "abc".getBytes();
        byte[] in = this.getClass().getName().getBytes();
        Iterator it = GnuCrypto.getMessageDigestNames().iterator();
        while (it.hasNext()) {
            String mdName = (String)it.next();
            try {
                MessageDigest md1 = MessageDigest.getInstance(mdName, "GNU-CRYPTO");
                md1.update(abc);
                MessageDigest md2 = (MessageDigest)md1.clone();
                byte[] ba1 = md1.digest(in);
                byte[] ba2 = md2.digest(in);
                harness.check(Util.areEqual((byte[])ba1, (byte[])ba2), "testCloneability(" + mdName + ")");
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("testCloneability(" + mdName + "): " + String.valueOf(x));
            }
        }
    }

    private void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }
}

