/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

class JCEUtil {
    private static final int MAX_ALIASES = 10;

    JCEUtil() {
    }

    /*
     * WARNING - void declaration
     */
    private static Implementation getImplementation(String baseName, String algorithm, Provider prov) {
        String alias;
        int count = 0;
        while ((alias = prov.getProperty("Alg.Alias." + baseName + "." + algorithm)) != null) {
            void var3_4;
            algorithm = var3_4;
            if (++count <= 10) continue;
            return null;
        }
        String className = prov.getProperty(baseName + "." + algorithm);
        if (className != null) {
            try {
                ClassLoader clsLoader = prov.getClass().getClassLoader();
                Class<?> cls = clsLoader != null ? clsLoader.loadClass(className) : Class.forName(className);
                return new Implementation(cls.newInstance(), prov);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("algorithm " + algorithm + " in provider " + prov.getName() + " but no class \"" + className + "\" found!");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("algorithm " + algorithm + " in provider " + prov.getName() + " but class \"" + className + "\" inaccessible!");
            }
        }
        return null;
    }

    static Implementation getImplementation(String baseName, String algorithm, String provider) throws NoSuchProviderException {
        if (provider == null) {
            Provider[] prov = Security.getProviders();
            int i = 0;
            while (i != prov.length) {
                Implementation imp = JCEUtil.getImplementation(baseName, algorithm.toUpperCase(), prov[i]);
                if (imp != null) {
                    return imp;
                }
                imp = JCEUtil.getImplementation(baseName, algorithm, prov[i]);
                if (imp != null) {
                    return imp;
                }
                ++i;
            }
        } else {
            Provider prov = Security.getProvider(provider);
            if (prov == null) {
                throw new NoSuchProviderException("Provider " + provider + " not found");
            }
            Implementation imp = JCEUtil.getImplementation(baseName, algorithm.toUpperCase(), prov);
            if (imp != null) {
                return imp;
            }
            return JCEUtil.getImplementation(baseName, algorithm, prov);
        }
        return null;
    }

    static class Implementation {
        Object engine;
        Provider provider;

        Implementation(Object engine, Provider provider) {
            this.engine = engine;
            this.provider = provider;
        }

        Object getEngine() {
            return this.engine;
        }

        Provider getProvider() {
            return this.provider;
        }
    }
}

