/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.dashboard.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openhab.core.OpenHAB;
import org.openhab.ui.dashboard.DashboardTile;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardServlet
extends HttpServlet {
    private static final long serialVersionUID = -5154582000538034381L;
    private static final Pattern MESSAGE_KEY_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private final Logger logger = LoggerFactory.getLogger(DashboardServlet.class);
    private ConfigurationAdmin configurationAdmin;
    private String indexTemplate;
    private String entryTemplate;
    private String warnTemplate;
    private String setupTemplate;
    private Set<DashboardTile> tiles;
    private Function<String, String> localizeFunction;

    public DashboardServlet(ConfigurationAdmin configurationAdmin, String indexTemplate, String entryTemplate, String warnTemplate, String setupTemplate, Set<DashboardTile> tiles, Function<String, String> localizeFunction) {
        this.configurationAdmin = configurationAdmin;
        this.indexTemplate = indexTemplate;
        this.entryTemplate = entryTemplate;
        this.warnTemplate = warnTemplate;
        this.setupTemplate = setupTemplate;
        this.tiles = tiles;
        this.localizeFunction = localizeFunction;
        this.isExposed(null);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isSetup()) {
            this.serveDashboard(req, resp);
        } else {
            this.serveSetup(req, resp);
        }
    }

    private void serveDashboard(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        StringBuilder entries = new StringBuilder();
        for (DashboardTile tile : this.tiles) {
            HashMap<String, String> entryMap = new HashMap<String, String>();
            entryMap.put("name", tile.getName());
            String overlay = tile.getOverlay() == null ? "none" : tile.getOverlay();
            entryMap.put("url", tile.getUrl());
            entryMap.put("overlay", overlay);
            entryMap.put("icon", tile.getImageUrl());
            entries.append(this.replaceKeysFromMap(this.entryTemplate, entryMap));
        }
        if (this.tiles.isEmpty()) {
            if ("minimal".equals(this.getPackage())) {
                entries.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                entries.append("${entry.no-ui-installed}");
            } else {
                entries.append("&nbsp;&nbsp;&nbsp;&nbsp;<div class=\"spinner spinner--steps\"><img src=\"img/spinner.svg\"></div>&nbsp;&nbsp;");
                entries.append("${entry.install-running}");
            }
        }
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("version", String.valueOf(OpenHAB.getVersion()) + " " + OpenHAB.buildString());
        replaceMap.put("entries", entries.toString());
        replaceMap.put("warn", this.isExposed(req) ? this.warnTemplate : "");
        resp.setContentType("text/html;charset=UTF-8");
        resp.getWriter().append(this.replaceKeysWithLocaleFunction(this.replaceKeysFromMap(this.indexTemplate, replaceMap)));
        resp.getWriter().close();
    }

    private void serveSetup(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("type") != null) {
            this.setPackage(req.getParameter("type"));
            resp.sendRedirect(req.getRequestURI());
        } else {
            HashMap<String, String> replaceMap = new HashMap<String, String>();
            replaceMap.put("version", String.valueOf(OpenHAB.getVersion()) + " " + OpenHAB.buildString());
            resp.setContentType("text/html;charset=UTF-8");
            resp.getWriter().append(this.replaceKeysWithLocaleFunction(this.replaceKeysFromMap(this.setupTemplate, replaceMap)));
            resp.getWriter().close();
        }
    }

    private void setPackage(String parameter) {
        try {
            Configuration cfg = this.configurationAdmin.getConfiguration("org.openhab.addons", null);
            Hashtable<String, String> props = cfg.getProperties();
            if (props == null) {
                props = new Hashtable<String, String>();
            }
            ((Dictionary)props).put("package", parameter);
            cfg.setBundleLocation(null);
            cfg.update(props);
        }
        catch (IOException e) {
            this.logger.error("Error while accessing the configuration admin: {}", (Object)e.getMessage());
        }
    }

    private boolean isExposed(HttpServletRequest req) {
        if (req != null) {
            if ("ihavelearnedmylesson".equals(req.getParameter("warn"))) {
                this.setExposed(false);
            } else if ("activate".equals(req.getParameter("warn"))) {
                this.setExposed(true);
            }
        }
        try {
            Configuration cfg = this.configurationAdmin.getConfiguration("org.openhab.dashboard");
            if (cfg != null && cfg.getProperties() != null && cfg.getProperties().get("exposed") != null && cfg.getProperties().get("nowarning") == null) {
                boolean value = cfg.getProperties().get("exposed").toString().equals(Boolean.TRUE.toString());
                if (value) {
                    this.logger.error("WARNING - YOUR HOME IS EXPOSED! It is accessible from the Internet without authentication - please take immediate action!");
                }
                return value;
            }
        }
        catch (IOException e) {
            this.logger.error("Error while accessing the configuration admin: {}", (Object)e.getMessage());
        }
        return false;
    }

    private void setExposed(boolean value) {
        try {
            Configuration cfg = this.configurationAdmin.getConfiguration("org.openhab.dashboard");
            Hashtable<String, Boolean> props = cfg.getProperties();
            if (props == null) {
                props = new Hashtable<String, Boolean>();
            }
            ((Dictionary)props).put("exposed", value);
            cfg.update(props);
        }
        catch (IOException e) {
            this.logger.error("Error while accessing the configuration admin: {}", (Object)e.getMessage());
        }
    }

    private boolean isSetup() {
        return this.getPackage() != null;
    }

    private String getPackage() {
        try {
            Configuration cfg = this.configurationAdmin.getConfiguration("org.openhab.addons", null);
            if (cfg != null && cfg.getProperties() != null && cfg.getProperties().get("package") != null) {
                return cfg.getProperties().get("package").toString();
            }
        }
        catch (IOException e) {
            this.logger.error("Error while accessing the configuration admin: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String replaceKeysWithLocaleFunction(String template) {
        return this.replaceKeysWithFunction(template, key -> this.localizeFunction.apply((String)key));
    }

    private String replaceKeysFromMap(String template, Map<String, String> map) {
        return this.replaceKeysWithFunction(template, key -> Matcher.quoteReplacement(map.getOrDefault(key, "${" + key + '}')));
    }

    private String replaceKeysWithFunction(String template, Function<String, String> getMessage) {
        Matcher m = MESSAGE_KEY_PATTERN.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            try {
                String key = m.group(1);
                m.appendReplacement(sb, getMessage.apply(key));
            }
            catch (Exception e) {
                this.logger.debug("Error occurred during template filling, cause ", (Throwable)e);
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

