/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.dashboard.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.net.HttpServiceUtil;
import org.eclipse.smarthome.core.net.NetworkAddressService;
import org.openhab.ui.dashboard.DashboardReady;
import org.openhab.ui.dashboard.DashboardTile;
import org.openhab.ui.dashboard.internal.DashboardServlet;
import org.openhab.ui.dashboard.internal.ExternalServiceTile;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DashboardService.class, DashboardReady.class}, immediate=true, name="org.openhab.dashboard")
public class DashboardService
implements DashboardReady {
    public static final String DASHBOARD_ALIAS = "/start";
    public static final String SERVLET_NAME = "index";
    private static final Logger logger = LoggerFactory.getLogger(DashboardService.class);
    protected HttpService httpService;
    protected ConfigurationAdmin configurationAdmin;
    protected NetworkAddressService networkAddressService;
    protected TranslationProvider i18nProvider;
    protected LocaleProvider localeProvider;
    protected Set<DashboardTile> tiles = new CopyOnWriteArraySet<DashboardTile>();
    private BundleContext bundleContext;
    private static final String LINK_NAME = "link-name";
    private static final String LINK_URL = "link-url";
    private static final String LINK_IMAGEURL = "link-imageurl";

    @Activate
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        try {
            this.bundleContext = componentContext.getBundleContext();
            Hashtable props = new Hashtable();
            this.httpService.registerServlet("/start/index", (Servlet)this.createServlet(), props, this.httpService.createDefaultHttpContext());
            this.httpService.registerResources(DASHBOARD_ALIAS, "web", null);
            if (HttpServiceUtil.getHttpServicePort((BundleContext)this.bundleContext) > 0) {
                logger.info("Started Dashboard at http://{}:{}", (Object)this.networkAddressService.getPrimaryIpv4HostAddress(), (Object)HttpServiceUtil.getHttpServicePort((BundleContext)this.bundleContext));
            }
            if (HttpServiceUtil.getHttpServicePortSecure((BundleContext)this.bundleContext) > 0) {
                logger.info("Started Dashboard at https://{}:{}", (Object)this.networkAddressService.getPrimaryIpv4HostAddress(), (Object)HttpServiceUtil.getHttpServicePortSecure((BundleContext)this.bundleContext));
            }
        }
        catch (ServletException | NamespaceException e) {
            logger.error("Error during Dashboard startup: {}", (Object)e.getMessage());
        }
        this.addTilesForExternalServices(properties);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.httpService.unregister("/start/index");
        this.httpService.unregister(DASHBOARD_ALIAS);
        logger.info("Stopped Dashboard");
    }

    @Reference
    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = null;
    }

    @Reference
    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    @Reference
    protected void setNetworkAddressService(NetworkAddressService networkAddressService) {
        this.networkAddressService = networkAddressService;
    }

    protected void unsetNetworkAddressService(NetworkAddressService networkAddressService) {
        this.networkAddressService = null;
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    @Reference
    public void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    public void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addDashboardTile(DashboardTile tile) {
        this.tiles.add(tile);
    }

    protected void removeDashboardTile(DashboardTile tile) {
        this.tiles.remove(tile);
    }

    protected HttpServlet createServlet() {
        String setupTemplate;
        String warnTemplate;
        String entryTemplate;
        String indexTemplate;
        URL index = this.bundleContext.getBundle().getEntry("templates/index.html");
        if (index != null) {
            try {
                indexTemplate = IOUtils.toString((InputStream)index.openStream());
            }
            catch (IOException e) {
                throw new ComponentException((Throwable)e);
            }
        } else {
            throw new ComponentException("Cannot find index.html - failed to initialize Dashboard servlet");
        }
        URL entry = this.bundleContext.getBundle().getEntry("templates/entry.html");
        if (entry != null) {
            try {
                entryTemplate = IOUtils.toString((InputStream)entry.openStream());
            }
            catch (IOException e) {
                throw new ComponentException((Throwable)e);
            }
        } else {
            throw new ComponentException("Cannot find entry.html - failed to initialize Dashboard servlet");
        }
        URL warn = this.bundleContext.getBundle().getEntry("templates/warn.html");
        if (warn != null) {
            try {
                warnTemplate = IOUtils.toString((InputStream)warn.openStream());
            }
            catch (IOException e) {
                throw new ComponentException((Throwable)e);
            }
        } else {
            throw new RuntimeException("Cannot find warn.html - failed to initialize Dashboard servlet");
        }
        URL setup = this.bundleContext.getBundle().getEntry("templates/setup.html");
        if (setup != null) {
            try {
                setupTemplate = IOUtils.toString((InputStream)setup.openStream());
            }
            catch (IOException e) {
                throw new ComponentException((Throwable)e);
            }
        } else {
            throw new ComponentException("Cannot find setup.html - failed to initialize Dashboard servlet");
        }
        return new DashboardServlet(this.configurationAdmin, indexTemplate, entryTemplate, warnTemplate, setupTemplate, this.tiles, this::getLocalizedText);
    }

    private void addTilesForExternalServices(Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            if (!key.endsWith(LINK_NAME) || key.length() <= LINK_NAME.length()) continue;
            String linkname = key.substring(0, key.length() - LINK_NAME.length());
            String name = (String)properties.get(String.valueOf(linkname) + LINK_NAME);
            String url = (String)properties.get(String.valueOf(linkname) + LINK_URL);
            String imageUrl = (String)properties.get(String.valueOf(linkname) + LINK_IMAGEURL);
            ExternalServiceTile newTile = new ExternalServiceTile.DashboardTileBuilder().withName(name).withUrl(url).withImageUrl(imageUrl).build();
            if (name != null && url != null && !name.isEmpty() && !url.isEmpty()) {
                this.addDashboardTile(newTile);
                logger.debug("Tile added to Dashboard: {}", (Object)newTile);
                continue;
            }
            logger.warn("Ignore invalid tile '{}': {}", (Object)linkname, (Object)newTile);
        }
    }

    private String getLocalizedText(String key) {
        Locale useLocale;
        Locale locale = useLocale = this.localeProvider.getLocale() == null ? Locale.ENGLISH : this.localeProvider.getLocale();
        if ("locale".equals(key)) {
            return this.bundleContext.getBundle().getEntry("ESH-INF/i18n/dashboard_" + useLocale.getLanguage() + ".properties") != null ? useLocale.getLanguage() : "en";
        }
        return this.i18nProvider.getText(this.bundleContext.getBundle(), key, key, useLocale);
    }
}

