/* GStreamer
 * Copyright (C) <2009> Sebastian Dröge <sebastian.droege@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MXF_UL_H__
#define __MXF_UL_H__

#include <gst/gst.h>

/* SMPTE 377M 3.2 */
typedef struct {
  guint8 u[16];
} MXFUL;

typedef enum {
  MXF_UL_SMPTE,
  MXF_UL_FILL,
  MXF_UL_PARTITION_PACK,
  MXF_UL_PRIMER_PACK,
  MXF_UL_METADATA,
  MXF_UL_DESCRIPTIVE_METADATA,
  MXF_UL_RANDOM_INDEX_PACK,
  MXF_UL_INDEX_TABLE_SEGMENT,
  MXF_UL_GENERIC_CONTAINER_SYSTEM_ITEM,
  MXF_UL_GENERIC_CONTAINER_ESSENCE_ELEMENT,
  MXF_UL_GENERIC_CONTAINER_ESSENCE_CONTAINER_LABEL,
  MXF_UL_AVID_ESSENCE_CONTAINER_ESSENCE_ELEMENT,
  MXF_UL_AVID_ESSENCE_CONTAINER_ESSENCE_LABEL,
  MXF_UL_OPERATIONAL_PATTERN_IDENTIFICATION,
  MXF_UL_TRACK_TIMECODE_12M_INACTIVE,
  MXF_UL_TRACK_TIMECODE_12M_ACTIVE,
  MXF_UL_TRACK_TIMECODE_309M,
  MXF_UL_TRACK_METADATA,
  MXF_UL_TRACK_PICTURE_ESSENCE,
  MXF_UL_TRACK_SOUND_ESSENCE,
  MXF_UL_TRACK_DATA_ESSENCE,
  MXF_UL_TRACK_AUXILIARY_DATA,
  MXF_UL_TRACK_PARSED_TEXT,
  MXF_UL_TRACK_AVID_PICTURE_ESSENCE,
  MXF_UL_INSTANCE_UID,
  MXF_UL_GENERATION_UID,
  MXF_UL_LAST_MODIFIED_DATE,
  MXF_UL_VERSION,
  MXF_UL_OBJECT_MODEL_VERSION,
  MXF_UL_PRIMARY_PACKAGE,
  MXF_UL_IDENTIFICATIONS,
  MXF_UL_CONTENT_STORAGE,
  MXF_UL_OPERATIONAL_PATTERN,
  MXF_UL_ESSENCE_CONTAINERS,
  MXF_UL_DM_SCHEMES,
  MXF_UL_COMPANY_NAME,
  MXF_UL_PRODUCT_NAME,
  MXF_UL_PRODUCT_VERSION,
  MXF_UL_VERSION_STRING,
  MXF_UL_PRODUCT_UID,
  MXF_UL_MODIFICATION_DATE,
  MXF_UL_TOOLKIT_VERSION,
  MXF_UL_PLATFORM,
  MXF_UL_PACKAGES,
  MXF_UL_ESSENCE_CONTAINER_DATA,
  MXF_UL_LINKED_PACKAGE_UID,
  MXF_UL_BODY_SID,
  MXF_UL_INDEX_SID,
  MXF_UL_PACKAGE_UID,
  MXF_UL_PACKAGE_NAME,
  MXF_UL_PACKAGE_CREATION_DATE,
  MXF_UL_PACKAGE_MODIFIED_DATE,
  MXF_UL_TRACKS,
  MXF_UL_DESCRIPTOR,
  MXF_UL_TRACK_ID,
  MXF_UL_TRACK_NUMBER,
  MXF_UL_TRACK_NAME,
  MXF_UL_SEQUENCE,
  MXF_UL_EDIT_RATE,
  MXF_UL_ORIGIN,
  MXF_UL_EVENT_EDIT_RATE,
  MXF_UL_EVENT_ORIGIN,
  MXF_UL_DATA_DEFINITION,
  MXF_UL_DURATION,
  MXF_UL_STRUCTURAL_COMPONENTS,
  MXF_UL_ROUNDED_TIMECODE_BASE,
  MXF_UL_START_TIMECODE,
  MXF_UL_DROP_FRAME,
  MXF_UL_START_POSITION,
  MXF_UL_SOURCE_PACKAGE_ID,
  MXF_UL_SOURCE_TRACK_ID,
  MXF_UL_DM_SOURCECLIP_TRACK_IDS,
  MXF_UL_EVENT_START_POSITION,
  MXF_UL_EVENT_COMMENT,
  MXF_UL_DM_SEGMENT_TRACK_IDS,
  MXF_UL_DM_FRAMEWORK,
  MXF_UL_LOCATORS,
  MXF_UL_LINKED_TRACK_ID,
  MXF_UL_SAMPLE_RATE,
  MXF_UL_CONTAINER_DURATION,
  MXF_UL_ESSENCE_CONTAINER,
  MXF_UL_CODEC,
  MXF_UL_SIGNAL_STANDARD,
  MXF_UL_FRAME_LAYOUT,
  MXF_UL_STORED_WIDTH,
  MXF_UL_STORED_HEIGHT,
  MXF_UL_STORED_F2_OFFSET,
  MXF_UL_SAMPLED_WIDTH,
  MXF_UL_SAMPLED_HEIGHT,
  MXF_UL_SAMPLED_X_OFFSET,
  MXF_UL_SAMPLED_Y_OFFSET,
  MXF_UL_DISPLAY_HEIGHT,
  MXF_UL_DISPLAY_WIDTH,
  MXF_UL_DISPLAY_X_OFFSET,
  MXF_UL_DISPLAY_Y_OFFSET,
  MXF_UL_DISPLAY_F2_OFFSET,
  MXF_UL_ASPECT_RATIO,
  MXF_UL_ACTIVE_FORMAT_DESCRIPTOR,
  MXF_UL_VIDEO_LINE_MAP,
  MXF_UL_ALPHA_TRANSPARENCY,
  MXF_UL_CAPTURE_GAMMA,
  MXF_UL_IMAGE_ALIGNMENT_OFFSET,
  MXF_UL_IMAGE_START_OFFSET,
  MXF_UL_IMAGE_END_OFFSET,
  MXF_UL_FIELD_DOMINANCE,
  MXF_UL_PICTURE_ESSENCE_CODING,
  MXF_UL_AUDIO_SAMPLING_RATE,
  MXF_UL_LOCKED,
  MXF_UL_AUDIO_REF_LEVEL,
  MXF_UL_ELECTRO_SPATIAL_FORMULATION,
  MXF_UL_CHANNEL_COUNT,
  MXF_UL_QUANTIZATION_BITS,
  MXF_UL_DIAL_NORM,
  MXF_UL_SOUND_ESSENCE_COMPRESSION,
  MXF_UL_COMPONENT_DEPTH,
  MXF_UL_HORIZONTAL_SUBSAMPLING,
  MXF_UL_VERTICAL_SUBSAMPLING,
  MXF_UL_COLOR_SITING,
  MXF_UL_REVERSED_BYTE_ORDER,
  MXF_UL_PADDING_BITS,
  MXF_UL_ALPHA_SAMPLE_DEPTH,
  MXF_UL_BLACK_REF_LEVEL,
  MXF_UL_WHITE_REF_LEVEL,
  MXF_UL_COLOR_RANGE,
  MXF_UL_COMPONENT_MAX_REF,
  MXF_UL_COMPONENT_MIN_REF,
  MXF_UL_ALPHA_MAX_REF,
  MXF_UL_ALPHA_MIN_REF,
  MXF_UL_SCANNING_DIRECTION,
  MXF_UL_PIXEL_LAYOUT,
  MXF_UL_DATA_ESSENCE_CODING,
  MXF_UL_SUB_DESCRIPTORS,
  MXF_UL_LOCATOR_NAME,
  MXF_UL_URL_STRING,
  MXF_UL_MAX
} MXFULId;

extern const MXFUL _mxf_ul_table[MXF_UL_MAX];

#define MXF_UL(id) (&_mxf_ul_table[MXF_UL_##id])

gboolean mxf_ul_is_equal (const MXFUL *a, const MXFUL *b);
gboolean mxf_ul_is_subclass (const MXFUL *class, const MXFUL *subclass);
gboolean mxf_ul_is_zero (const MXFUL *ul);
gboolean mxf_ul_is_valid (const MXFUL *ul);
guint mxf_ul_hash (const MXFUL *ul);

gchar * mxf_ul_to_string (const MXFUL *ul, gchar str[48]);
MXFUL * mxf_ul_from_string (const gchar *str, MXFUL *ul);

gboolean mxf_ul_array_parse (MXFUL **array, guint32 *count, const guint8 *data, guint size);

#endif /* __MXF_UL_H__ */
