/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestYaml {
    @Test
    public void testFalseDetectionAsKubernetes() throws Exception {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("p");
        p.create((IProgressMonitor)new NullProgressMonitor());
        p.open((IProgressMonitor)new NullProgressMonitor());
        IFile file = p.getFile("blah.yaml");
        file.create(new byte[0], true, false, (IProgressMonitor)new NullProgressMonitor());
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.set("name: a\ndescrition: b");
        boolean markerFound = DisplayHelper.waitForCondition((Display)activePage.getWorkbenchWindow().getShell().getDisplay(), (long)3000L, () -> {
            try {
                return file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0).length > 0;
            }
            catch (CoreException e) {
                return false;
            }
        });
        Assertions.assertFalse((boolean)markerFound, (String)Arrays.stream(file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0)).map(Object::toString).collect(Collectors.joining("\n")));
    }

    private void testErrorFile(String name) throws Exception {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("p");
        p.create((IProgressMonitor)new NullProgressMonitor());
        p.open((IProgressMonitor)new NullProgressMonitor());
        IFile file = p.getFile(name);
        file.create(new byte[0], true, false, (IProgressMonitor)new NullProgressMonitor());
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.set("{version: 1}");
        boolean markerFound = DisplayHelper.waitForCondition((Display)activePage.getWorkbenchWindow().getShell().getDisplay(), (long)6000L, () -> {
            try {
                return file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0).length > 0;
            }
            catch (CoreException e) {
                return false;
            }
        });
        Assertions.assertTrue((boolean)markerFound, (String)Arrays.stream(file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0)).map(Object::toString).collect(Collectors.joining("\n")));
    }

    @Test
    public void testSchemaExtensionPoint() throws Exception {
        this.testErrorFile("dep.yml");
    }

    @Test
    public void testSchemaExtensionPointUsingPlatformURL() throws Exception {
        this.testErrorFile("depp.yml");
    }
}

