/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ExtendWith(value={AllCleanRule.class})
public class TestXML {
    private IProject project;
    private ICompletionProposal[] proposals;

    @BeforeEach
    public void setUpProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
    }

    @Test
    public void testXMLFile() throws Exception {
        IFile file = this.project.getFile("blah.xml");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<plugin></");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testXSLFile() throws Exception {
        IFile file = this.project.getFile("blah.xsl");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testXSDFile() throws Exception {
        IFile file = this.project.getFile("blah.xsd");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testDTDFile() throws Exception {
        IFile file = this.project.getFile("blah.dtd");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<!--<!-- -->");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testComplexXML() throws Exception {
        IFile file = this.project.getFile("blah.xml");
        String content = "<layout:BlockLayoutCell\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\t\n    xsi:schemaLocation=\"sap.ui.layout https://openui5.hana.ondemand.com/downloads/schemas/sap.ui.layout.xsd\"\n\txmlns:layout=\"sap.ui.layout\">\n    |\n</layout:BlockLayoutCell>";
        int offset = content.indexOf(124);
        content = content.replace("|", "");
        file.create(content.getBytes(), true, false, null);
        AbstractTextEditor editor = (AbstractTextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (String)"org.eclipse.ui.genericeditor.GenericEditor");
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, 0));
        LSContentAssistProcessor processor = new LSContentAssistProcessor();
        this.proposals = processor.computeCompletionProposals((ITextViewer)Utils.getViewer(editor), offset);
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)editor.getSite().getShell().getDisplay(), (long)10000L, () -> {
            this.proposals = processor.computeCompletionProposals((ITextViewer)Utils.getViewer(editor), offset);
            return this.proposals != null && this.proposals.length > 1;
        }), (String)"Expected at least 2 XML completion proposals");
    }

    @Test
    public void autoCloseTags() throws Exception {
        IFile file = this.project.getFile("autoCloseTags.xml");
        file.create("<foo".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.replace(4, 0, ">");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> "<foo></foo>".equals(document.get())), (String)"Autoclose not done");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testXMLCatalog() throws Exception {
        Bundle catalogBundle;
        Object fileOut;
        Path bundlePath;
        block23: {
            bundlePath = Files.createTempFile("xmlCatalogTest", "bundle.jar", new FileAttribute[0]);
            bundlePath.toFile().deleteOnExit();
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                FileOutputStream bundleOutput = new FileOutputStream(bundlePath.toFile());
                try {
                    try (JarOutputStream bundleJarOut = new JarOutputStream(bundleOutput);){
                        bundleJarOut.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
                        fileOut = new PrintWriter(bundleJarOut, true, StandardCharsets.UTF_8);
                        ((PrintWriter)fileOut).println("Manifest-Version: 1.0");
                        ((PrintWriter)fileOut).println("Bundle-ManifestVersion: 2");
                        ((PrintWriter)fileOut).println("Bundle-Name: XML-Catalog-Test");
                        ((PrintWriter)fileOut).println("Bundle-SymbolicName: org.eclipse.wildwebdeveloper.test.xmlcatalog;singleton:=true");
                        ((PrintWriter)fileOut).println("Bundle-Version: 0.0.1");
                        ((PrintWriter)fileOut).println("Require-Bundle: org.eclipse.wst.xml.core");
                        bundleJarOut.putNextEntry(new JarEntry("plugin.xml"));
                        fileOut = new PrintWriter(bundleJarOut, true, StandardCharsets.UTF_8);
                        ((PrintWriter)fileOut).println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        ((PrintWriter)fileOut).println("<?eclipse version=\"3.0\"?>");
                        ((PrintWriter)fileOut).println("<plugin>");
                        ((PrintWriter)fileOut).println("<extension point=\"org.eclipse.wst.xml.core.catalogContributions\">");
                        ((PrintWriter)fileOut).println("<catalogContribution id=\"Test\">");
                        ((PrintWriter)fileOut).println("<uri name=\"http://eclipse.org/wildwebdeveloper/test\" ");
                        ((PrintWriter)fileOut).println("uri=\"/org/eclipse/wildwebdeveloper/test/schema.xsd\"/>");
                        ((PrintWriter)fileOut).println("</catalogContribution>");
                        ((PrintWriter)fileOut).println("</extension>");
                        ((PrintWriter)fileOut).println("</plugin>");
                        bundleJarOut.putNextEntry(new JarEntry("org/eclipse/wildwebdeveloper/test/schema.xsd"));
                        fileOut = new PrintWriter(bundleJarOut, true, StandardCharsets.UTF_8);
                        ((PrintWriter)fileOut).println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        ((PrintWriter)fileOut).println("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://eclipse.org/wildwebdeveloper/test\" xmlns:com=\"http://acme.com/order\">");
                        ((PrintWriter)fileOut).println("<xs:element name=\"order\" type=\"com:ordertype\" />");
                        ((PrintWriter)fileOut).println("<xs:complexType name=\"ordertype\">");
                        ((PrintWriter)fileOut).println("<xs:sequence>");
                        ((PrintWriter)fileOut).println("<xs:element name=\"person\" type=\"xs:string\" />");
                        ((PrintWriter)fileOut).println("<xs:element name=\"item\" maxOccurs=\"unbounded\" type=\"xs:string\" />");
                        ((PrintWriter)fileOut).println("</xs:sequence>");
                        ((PrintWriter)fileOut).println("<xs:attribute name=\"orderid\" type=\"xs:string\" use=\"required\" />");
                        ((PrintWriter)fileOut).println("</xs:complexType>");
                        ((PrintWriter)fileOut).println("</xs:schema>");
                        bundleJarOut.closeEntry();
                    }
                    if (bundleOutput == null) break block23;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bundleOutput == null) throw throwable;
                    bundleOutput.close();
                    throw throwable;
                }
                bundleOutput.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        Activator plugin = Activator.getDefault();
        BundleContext bundleContext = plugin.getBundle().getBundleContext();
        URL bundleUrl = bundlePath.toUri().toURL();
        fileOut = null;
        Object var7_11 = null;
        try (InputStream is = bundleUrl.openStream();){
            catalogBundle = bundleContext.installBundle(bundleUrl.toExternalForm(), is);
        }
        catch (Throwable throwable) {
            if (fileOut == null) {
                fileOut = throwable;
                throw fileOut;
            }
            if (fileOut == throwable) throw fileOut;
            ((Throwable)fileOut).addSuppressed(throwable);
            throw fileOut;
        }
        try {
            catalogBundle.start();
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLCatalogPreferencePage", null, null);
            dialog.getShell().open();
            dialog.getShell().close();
            File systemCatalog = plugin.getStateLocation().append("system-catalog.xml").toFile();
            Document systemCatalogDom = this.runWithLocalCatalogOnlyForTestXMLCatalog(() -> DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder().parse(systemCatalog));
            Node catalogNode = systemCatalogDom.getLastChild();
            Assertions.assertEquals((short)1, (short)catalogNode.getNodeType());
            Assertions.assertEquals((Object)"catalog", (Object)catalogNode.getNodeName());
            NodeList catalogEntries = catalogNode.getChildNodes();
            List uriNodes = IntStream.range(0, catalogEntries.getLength()).mapToObj(catalogEntries::item).filter(n -> n.getNodeType() == 1).filter(n -> "uri".equals(n.getNodeName())).collect(Collectors.toList());
            Assertions.assertFalse((boolean)uriNodes.isEmpty(), (String)"uri-nodes expected");
            List expectedNodes = uriNodes.stream().filter(n -> "http://eclipse.org/wildwebdeveloper/test".equals(n.getAttributes().getNamedItem("name").getNodeValue())).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)expectedNodes.size(), (String)"one uri-node with the used name expected");
            Node uriNode = (Node)expectedNodes.get(0);
            Assertions.assertNotNull((Object)uriNode.getAttributes().getNamedItem("uri"), (String)"uri-attribute expected");
            String uri = uriNode.getAttributes().getNamedItem("uri").getNodeValue();
            Assertions.assertNotNull((Object)uri, (String)"value fro uri expected");
            Assertions.assertTrue((boolean)uri.startsWith("jar:file:/"), (String)("jar-uri expected: " + uri));
            Assertions.assertTrue((boolean)uri.endsWith("/org/eclipse/wildwebdeveloper/test/schema.xsd"), (String)("relative path of schema in uri expected: " + uri));
            return;
        }
        finally {
            catalogBundle.uninstall();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T runWithLocalCatalogOnlyForTestXMLCatalog(Callable<T> callable) throws Exception {
        origSysProps = new HashMap<K, V>();
        List.of("javax.xml.useCatalog", "javax.xml.catalog.files", "javax.xml.catalog.prefer", "javax.xml.catalog.resolve").forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$11(java.util.HashMap java.lang.String ), (Ljava/lang/String;)V)(origSysProps));
        catalogRedirect = Path.of("src/org/eclipse/wildwebdeveloper/tests/catalog/oasis-catalog-redirect.xml", new String[0]);
        Assertions.assertTrue((boolean)Files.exists(catalogRedirect, new LinkOption[0]));
        System.setProperty("javax.xml.useCatalog", "true");
        System.setProperty("javax.xml.catalog.files", catalogRedirect.toUri().toString());
        System.setProperty("javax.xml.catalog.prefer", "system");
        System.setProperty("javax.xml.catalog.resolve", "strict");
        try {
            var5_4 = callable.call();
            return var5_4;
        }
        finally {
            ** for (e : origSysProps.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            if (e.getValue() == null) {
                System.clearProperty((String)e.getKey());
                continue;
            }
            System.setProperty((String)e.getKey(), (String)e.getValue());
            continue;
        }
lbl25:
        // 1 sources

        return var5_4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testXMLCatalogHttpsUriIncluded() throws Exception {
        Bundle catalogBundle;
        Path bundlePath;
        block23: {
            String HTTPS_NAME = "http://eclipse.org/wildwebdeveloper/https-test";
            String HTTPS_URI = "https://jakarta.ee/xml/ns/jakartaee/beans_3_0.xsd";
            bundlePath = Files.createTempFile("xmlCatalogHttpsTest", "bundle.jar", new FileAttribute[0]);
            bundlePath.toFile().deleteOnExit();
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                FileOutputStream bundleOutput = new FileOutputStream(bundlePath.toFile());
                try {
                    try (JarOutputStream bundleJarOut = new JarOutputStream(bundleOutput);){
                        bundleJarOut.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
                        bundleJarOut.write("Manifest-Version: 1.0\nBundle-ManifestVersion: 2\nBundle-Name: XML-Catalog-HTTPS-Test\nBundle-SymbolicName: org.eclipse.wildwebdeveloper.test.xmlcatalog.https;singleton:=true\nBundle-Version: 0.0.1\nRequire-Bundle: org.eclipse.wst.xml.core\n".getBytes(StandardCharsets.UTF_8));
                        bundleJarOut.closeEntry();
                        bundleJarOut.putNextEntry(new JarEntry("plugin.xml"));
                        bundleJarOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.0\"?>\n<plugin>\n  <extension point=\"org.eclipse.wst.xml.core.catalogContributions\">\n    <catalogContribution id=\"TestHttps\">\n      <uri name=\"%s\" uri=\"%s\"/>\n    </catalogContribution>\n  </extension>\n</plugin>\n".formatted("http://eclipse.org/wildwebdeveloper/https-test", "https://jakarta.ee/xml/ns/jakartaee/beans_3_0.xsd").getBytes(StandardCharsets.UTF_8));
                        bundleJarOut.closeEntry();
                    }
                    if (bundleOutput == null) break block23;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bundleOutput == null) throw throwable;
                    bundleOutput.close();
                    throw throwable;
                }
                bundleOutput.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        Activator plugin = Activator.getDefault();
        BundleContext bundleContext = plugin.getBundle().getBundleContext();
        URL bundleUrl = bundlePath.toUri().toURL();
        Throwable throwable = null;
        Object var9_13 = null;
        try (InputStream is = bundleUrl.openStream();){
            catalogBundle = bundleContext.installBundle(bundleUrl.toExternalForm(), is);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
        try {
            catalogBundle.start();
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLCatalogPreferencePage", null, null);
            dialog.getShell().open();
            dialog.getShell().close();
            File systemCatalog = plugin.getStateLocation().append("system-catalog.xml").toFile();
            Document systemCatalogDom = this.runWithLocalCatalogOnlyForTestXMLCatalog(() -> DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder().parse(systemCatalog));
            Node catalogNode = systemCatalogDom.getLastChild();
            Assertions.assertEquals((short)1, (short)catalogNode.getNodeType());
            Assertions.assertEquals((Object)"catalog", (Object)catalogNode.getNodeName());
            NodeList catalogEntries = catalogNode.getChildNodes();
            List<Node> uriNodes = IntStream.range(0, catalogEntries.getLength()).mapToObj(catalogEntries::item).filter(n -> n.getNodeType() == 1).filter(n -> "uri".equals(n.getNodeName())).toList();
            Assertions.assertFalse((boolean)uriNodes.isEmpty(), (String)"uri-nodes expected");
            List<Node> expectedNodes = uriNodes.stream().filter(n -> "http://eclipse.org/wildwebdeveloper/https-test".equals(n.getAttributes().getNamedItem("name").getNodeValue())).toList();
            Assertions.assertEquals((int)1, (int)expectedNodes.size(), (String)"one https uri-node with the used name expected");
            Node uriNode = expectedNodes.get(0);
            Assertions.assertNotNull((Object)uriNode.getAttributes().getNamedItem("uri"), (String)"uri-attribute expected");
            String uri = uriNode.getAttributes().getNamedItem("uri").getNodeValue();
            Assertions.assertEquals((Object)"https://jakarta.ee/xml/ns/jakartaee/beans_3_0.xsd", (Object)uri, (String)"https uri value should be preserved in catalog");
            return;
        }
        finally {
            catalogBundle.uninstall();
        }
    }

    private static /* synthetic */ void lambda$11(HashMap hashMap, String k) {
        String string = hashMap.put(k, System.getProperty(k));
    }
}

