/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.BinaryPattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import java.util.Set;

public class MyRequiredElementsFunction
extends AbstractPatternFunction<Void> {
    private final Set<String> requiredElementNames;

    public MyRequiredElementsFunction(Set<String> requiredElementNames) {
        this.requiredElementNames = requiredElementNames;
    }

    @Override
    public Void caseOther(Pattern p) {
        return null;
    }

    @Override
    public Void caseElement(ElementPattern p) {
        return this.caseNamed(p.getNameClass());
    }

    @Override
    public Void caseGroup(GroupPattern p) {
        return this.union(p);
    }

    @Override
    public Void caseChoice(ChoicePattern p) {
        Pattern p1 = p.getOperand1();
        if (!p1.isNullable()) {
            p1.apply(this);
        } else {
            Pattern p2 = p.getOperand2();
            if (!p2.isNullable()) {
                p2.apply(this);
            }
        }
        return null;
    }

    @Override
    public Void caseInterleave(InterleavePattern p) {
        return this.union(p);
    }

    @Override
    public Void caseAfter(AfterPattern p) {
        return p.getOperand1().apply(this);
    }

    @Override
    public Void caseOneOrMore(OneOrMorePattern p) {
        return p.getOperand().apply(this);
    }

    private Void caseNamed(NameClass nc) {
        if (!(nc instanceof SimpleNameClass)) {
            return null;
        }
        this.requiredElementNames.add(((SimpleNameClass)nc).getName().getLocalName());
        return null;
    }

    private Void union(BinaryPattern p) {
        Pattern p2;
        Pattern p1 = p.getOperand1();
        if (!p1.isNullable()) {
            p1.apply(this);
        }
        if (!(p2 = p.getOperand2()).isNullable()) {
            p2.apply(this);
        }
        return null;
    }
}

