/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.view;

import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vorto.core.api.repository.GeneratorResource;
import org.eclipse.vorto.core.api.repository.ModelResource;
import org.eclipse.vorto.perspective.view.GeneratorItem;

public class GeneratorDialog
extends TitleAreaDialog {
    private ModelResource model;
    private List<GeneratorResource> codegens;

    public GeneratorDialog(Shell parentShell, ModelResource model, List<GeneratorResource> codegens) {
        super(parentShell);
        this.model = model;
        this.codegens = codegens;
    }

    public void create() {
        super.create();
        this.setTitle("Generator Overview");
        this.setMessage("Choose the generator and click generate button, and the code will be automatically downloaded in the current workspace folder.", 1);
        this.getButton(0).setVisible(false);
        this.getButton(1).setText("Close");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        ScrolledComposite scrolledComposite = new ScrolledComposite(area, 2816);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridData gd_scrolledComposite = new GridData(4, 4, true, true, 1, 1);
        gd_scrolledComposite.heightHint = 300;
        scrolledComposite.setLayoutData((Object)gd_scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        for (GeneratorResource gen : this.codegens) {
            new GeneratorItem(composite, 0, this.model, gen);
        }
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        return area;
    }

    protected void okPressed() {
        super.okPressed();
    }
}

