/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.view;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.perspective.command.DeleteModelAction;
import org.eclipse.vorto.perspective.command.ProjectAction;
import org.eclipse.vorto.perspective.command.ShareModelAction;
import org.eclipse.vorto.perspective.dnd.ModelDragListener;
import org.eclipse.vorto.perspective.dnd.ModelDropListenerFactory;
import org.eclipse.vorto.perspective.util.ImageUtil;
import org.eclipse.vorto.perspective.view.ILocalModelWorkspace;
import org.eclipse.vorto.perspective.view.ModelTreeViewer;
import org.eclipse.vorto.wizard.datatype.EntityWizard;
import org.eclipse.vorto.wizard.datatype.EnumWizard;

public class DatatypeTreeViewer
extends ModelTreeViewer {
    public DatatypeTreeViewer(Composite parent, ILocalModelWorkspace localModelBrowser) {
        super(parent, localModelBrowser);
    }

    @Override
    protected void init() {
        super.init();
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.treeViewer.addDragSupport(operations, transferTypes, new ModelDragListener((StructuredViewer)this.treeViewer));
        this.treeViewer.addDropSupport(operations, transferTypes, ModelDropListenerFactory.datatypeViewPartDropListener((Viewer)this.treeViewer, this.localModelWorkspace));
    }

    @Override
    protected String getLabel() {
        return "Datatypes";
    }

    @Override
    protected void initContextMenu() {
        final MenuManager menuMgr = new MenuManager("#PopupMenuDt");
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IModelElement model;
                if (!DatatypeTreeViewer.this.treeViewer.getStructuredSelection().isEmpty() && (model = (IModelElement)DatatypeTreeViewer.this.treeViewer.getStructuredSelection().getFirstElement()).getId().getModelType() == ModelType.Datatype) {
                    menuMgr.add((IAction)ShareModelAction.newInstance(DatatypeTreeViewer.this.treeViewer, model));
                    menuMgr.add((IAction)DeleteModelAction.newInstance(DatatypeTreeViewer.this.localModelWorkspace, DatatypeTreeViewer.this.treeViewer, model));
                    menuMgr.add((IAction)new ProjectAction("New Mapping Model", ImageUtil.getImage("add_obj.gif"), DatatypeTreeViewer.this.treeViewer.getLocalModelWorkspace()){

                        @Override
                        public void doAction() {
                            DatatypeTreeViewer.this.openMappingWizard();
                        }
                    });
                }
                manager.add((IAction)new ProjectAction("New Entity", ImageUtil.getImage("add_obj.gif"), DatatypeTreeViewer.this.treeViewer.getLocalModelWorkspace()){

                    @Override
                    public void doAction() {
                        WizardDialog wizardDialog = new WizardDialog((this).DatatypeTreeViewer.this.treeViewer.getControl().getShell(), (IWizard)new EntityWizard((this).DatatypeTreeViewer.this.treeViewer.getLocalModelWorkspace().getProjectBrowser().getSelectedProject()));
                        if (wizardDialog.open() == 0) {
                            DatatypeTreeViewer.this.populate((this).DatatypeTreeViewer.this.treeViewer.getLocalModelWorkspace().getProjectBrowser().getSelectedProject().getModelElementsByType(ModelType.Datatype));
                        }
                    }
                });
                manager.add((IAction)new ProjectAction("New Enum", ImageUtil.getImage("add_obj.gif"), DatatypeTreeViewer.this.treeViewer.getLocalModelWorkspace()){

                    @Override
                    public void doAction() {
                        WizardDialog wizardDialog = new WizardDialog((this).DatatypeTreeViewer.this.treeViewer.getControl().getShell(), (IWizard)new EnumWizard((this).DatatypeTreeViewer.this.treeViewer.getLocalModelWorkspace().getProjectBrowser().getSelectedProject()));
                        if (wizardDialog.open() == 0) {
                            DatatypeTreeViewer.this.populate((this).DatatypeTreeViewer.this.treeViewer.getLocalModelWorkspace().getProjectBrowser().getSelectedProject().getModelElementsByType(ModelType.Datatype));
                        }
                    }
                });
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.treeViewer.getControl().setMenu(menu);
    }
}

