/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IGeneratorLookup;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.mapping.DefaultMapped;
import org.eclipse.vorto.codegen.api.mapping.IMapped;
import org.eclipse.vorto.codegen.api.mapping.NullMapped;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.mapping.ConfigurationSource;
import org.eclipse.vorto.core.api.model.mapping.EntityAttributeSource;
import org.eclipse.vorto.core.api.model.mapping.EntityPropertySource;
import org.eclipse.vorto.core.api.model.mapping.EnumAttributeSource;
import org.eclipse.vorto.core.api.model.mapping.EnumPropertySource;
import org.eclipse.vorto.core.api.model.mapping.FaultSource;
import org.eclipse.vorto.core.api.model.mapping.FunctionBlockAttributeSource;
import org.eclipse.vorto.core.api.model.mapping.FunctionBlockSource;
import org.eclipse.vorto.core.api.model.mapping.InfoModelAttributeSource;
import org.eclipse.vorto.core.api.model.mapping.InfomodelSource;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.mapping.MappingRule;
import org.eclipse.vorto.core.api.model.mapping.ModelAttribute;
import org.eclipse.vorto.core.api.model.mapping.OperationSource;
import org.eclipse.vorto.core.api.model.mapping.Source;
import org.eclipse.vorto.core.api.model.mapping.StatusSource;
import org.eclipse.vorto.core.api.model.mapping.StereoTypeTarget;
import org.eclipse.vorto.core.api.model.model.Model;

public class InvocationContext {
    private List<MappingRule> mappingRules = new ArrayList<MappingRule>();
    private Map<String, String> configProperties;
    private IGeneratorLookup lookupService;
    private static final IGeneratorLookup NOOP_RUNTIME = new NoopGeneratorLookup();
    private static final IVortoCodeGenerator NOOP_GEN = new NoopGenerator();

    public InvocationContext(List<MappingModel> mappingModels, IGeneratorLookup generatorRuntime, Map<String, String> configProperties) {
        for (MappingModel mappingModel : mappingModels) {
            this.mappingRules.addAll((Collection<MappingRule>)mappingModel.getRules());
        }
        this.lookupService = generatorRuntime != null ? generatorRuntime : NOOP_RUNTIME;
        this.configProperties = configProperties;
    }

    public static InvocationContext simpleInvocationContext() {
        return new InvocationContext(new ArrayList<MappingModel>(), NOOP_RUNTIME, Collections.emptyMap());
    }

    public static InvocationContext simpleInvocationContext(Map<String, String> configProperties) {
        return new InvocationContext(new ArrayList<MappingModel>(), NOOP_RUNTIME, configProperties);
    }

    public IMapped<InformationModel> getMappedElement(InformationModel informationModel, String stereoType) {
        for (MappingRule rule : this.mappingRules) {
            for (Source ruleSource : rule.getSources()) {
                if (!(ruleSource instanceof InfomodelSource) || !EcoreUtil.equals((EObject)((InfomodelSource)ruleSource).getModel(), (EObject)informationModel) || !this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) continue;
                return new DefaultMapped<InformationModel>(informationModel, (StereoTypeTarget)rule.getTarget());
            }
        }
        return new NullMapped<InformationModel>(informationModel);
    }

    public IMapped<FunctionblockModel> getMappedElement(FunctionblockModel functionblockModel, String stereoType) {
        for (MappingRule rule : this.mappingRules) {
            for (Source ruleSource : rule.getSources()) {
                if (!(ruleSource instanceof FunctionBlockSource) || !EcoreUtil.equals((EObject)((FunctionBlockSource)ruleSource).getModel(), (EObject)functionblockModel) || !this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) continue;
                return new DefaultMapped<FunctionblockModel>(functionblockModel, (StereoTypeTarget)rule.getTarget());
            }
        }
        return new NullMapped<FunctionblockModel>(functionblockModel);
    }

    public IMapped<EnumLiteral> getMappedElement(EnumLiteral enumLiteral, String stereoType) {
        for (MappingRule rule : this.mappingRules) {
            for (Source ruleSource : rule.getSources()) {
                if (!(ruleSource instanceof EnumPropertySource) || !EcoreUtil.equals((EObject)((EnumPropertySource)ruleSource).getProperty(), (EObject)enumLiteral) || !this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) continue;
                return new DefaultMapped<EnumLiteral>(enumLiteral, (StereoTypeTarget)rule.getTarget());
            }
        }
        return new NullMapped<EnumLiteral>(enumLiteral);
    }

    private boolean matchesStereoType(String stereoType, StereoTypeTarget stereoTypeTarget) {
        return stereoTypeTarget.getName().equalsIgnoreCase(stereoType);
    }

    public IMapped<Property> getMappedElement(Property property, String stereoType) {
        for (MappingRule rule : this.mappingRules) {
            for (Source ruleSource : rule.getSources()) {
                if (ruleSource instanceof ConfigurationSource && EcoreUtil.equals((EObject)((ConfigurationSource)ruleSource).getProperty(), (EObject)property) && this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) {
                    return new DefaultMapped<Property>(property, (StereoTypeTarget)rule.getTarget());
                }
                if (ruleSource instanceof StatusSource && EcoreUtil.equals((EObject)((StatusSource)ruleSource).getProperty(), (EObject)property) && this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) {
                    return new DefaultMapped<Property>(property, (StereoTypeTarget)rule.getTarget());
                }
                if (ruleSource instanceof FaultSource && EcoreUtil.equals((EObject)((FaultSource)ruleSource).getProperty(), (EObject)property) && this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) {
                    return new DefaultMapped<Property>(property, (StereoTypeTarget)rule.getTarget());
                }
                if (!(ruleSource instanceof EntityPropertySource) || !EcoreUtil.equals((EObject)((EntityPropertySource)ruleSource).getProperty(), (EObject)property) || !this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) continue;
                return new DefaultMapped<Property>(property, (StereoTypeTarget)rule.getTarget());
            }
        }
        return new NullMapped<Property>(property);
    }

    public IMapped<Operation> getMappedElement(Operation operation, String stereoType) {
        for (MappingRule rule : this.mappingRules) {
            for (Source ruleSource : rule.getSources()) {
                if (!(ruleSource instanceof OperationSource) || !EcoreUtil.equals((EObject)((OperationSource)ruleSource).getOperation(), (EObject)operation) || !this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) continue;
                return new DefaultMapped<Operation>(operation, (StereoTypeTarget)rule.getTarget());
            }
        }
        return new NullMapped<Operation>(operation);
    }

    public IMapped<ModelAttribute> getMappedModelAttribute(Model model, ModelAttribute attribute, String stereoType) {
        for (MappingRule rule : this.mappingRules) {
            for (Source ruleSource : rule.getSources()) {
                if (model instanceof InformationModel && ruleSource instanceof InfoModelAttributeSource && ((InfoModelAttributeSource)ruleSource).getAttribute().equals((Object)attribute) && this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) {
                    return new DefaultMapped<ModelAttribute>(attribute, (StereoTypeTarget)rule.getTarget());
                }
                if (model instanceof FunctionblockModel && ruleSource instanceof FunctionBlockAttributeSource && ((FunctionBlockAttributeSource)ruleSource).getAttribute().equals((Object)attribute) && this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) {
                    return new DefaultMapped<ModelAttribute>(attribute, (StereoTypeTarget)rule.getTarget());
                }
                if (model instanceof Enum && ruleSource instanceof EnumAttributeSource && ((EnumAttributeSource)ruleSource).getAttribute().equals((Object)attribute) && this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) {
                    return new DefaultMapped<ModelAttribute>(attribute, (StereoTypeTarget)rule.getTarget());
                }
                if (!(model instanceof Entity) || !(ruleSource instanceof EnumAttributeSource) || !((EntityAttributeSource)ruleSource).getAttribute().equals((Object)attribute) || !this.matchesStereoType(stereoType, (StereoTypeTarget)rule.getTarget())) continue;
                return new DefaultMapped<ModelAttribute>(attribute, (StereoTypeTarget)rule.getTarget());
            }
        }
        return new NullMapped<ModelAttribute>(attribute);
    }

    public IVortoCodeGenerator lookupGenerator(String key) {
        IVortoCodeGenerator gen = this.lookupService.lookupByKey(key);
        if (gen == null) {
            return NOOP_GEN;
        }
        return gen;
    }

    public Map<String, String> getConfigurationProperties() {
        return Collections.unmodifiableMap(this.configProperties);
    }

    static class NoopGenerator
    implements IVortoCodeGenerator {
        NoopGenerator() {
        }

        @Override
        public IGenerationResult generate(InformationModel model, InvocationContext context) throws Exception {
            return null;
        }

        @Override
        public String getServiceKey() {
            return "noop";
        }
    }

    static class NoopGeneratorLookup
    implements IGeneratorLookup {
        NoopGeneratorLookup() {
        }

        @Override
        public IVortoCodeGenerator lookupByKey(String key) {
            return NOOP_GEN;
        }
    }
}

