/*******************************************************************************
 * Copyright (c) 2015 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *   
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *   
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *******************************************************************************/
package org.eclipse.vorto.codegen.examples.templates.java

import org.eclipse.vorto.codegen.api.ITemplate
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel
import org.eclipse.vorto.codegen.api.InvocationContext

class JavaInformationModelInterfaceTemplate implements ITemplate<InformationModel>{
	
	var String classPackage
	var String[] imports
	var String interfacePrefix
	var ITemplate<FunctionblockProperty> getterDeclarationTemplate
	var ITemplate<FunctionblockProperty> setterDeclarationTemplate
	
	new(String classPackage, 
		String interfacePrefix,
		String[] imports,
		ITemplate<FunctionblockProperty> getterTemplate, 
		ITemplate<FunctionblockProperty> setterTemplate) {
			this.classPackage=classPackage
			this.interfacePrefix = interfacePrefix
			this.imports = imports
			this.getterDeclarationTemplate = getterTemplate
			this.setterDeclarationTemplate = setterTemplate
	}
	
	override getContent(InformationModel im,InvocationContext invocationContext) {
		'''
			/*
			*****************************************************************************************
			* The present code has been generated by the Eclipse Vorto Java Code Generator.
			*
			* The basis for the generation was the Information Model which is uniquely identified by:
			* Name:			«im.name»
			* Namespace:	«im.namespace»
			* Version:		«im.version»
			*****************************************************************************************
			*/
			
			package «classPackage»;
			
			«FOR imprt :imports»
				import «imprt».*;
			«ENDFOR»
			
			/**
			* «im.description»
			*/
			public interface «interfacePrefix»«im.name.toFirstUpper» {

				«FOR fbProperty : im.properties»
					«getterDeclarationTemplate.getContent(fbProperty,invocationContext)»
					
					«setterDeclarationTemplate.getContent(fbProperty,invocationContext)»
										
				«ENDFOR»
			}
		'''
	}
}