/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;

abstract class EXTDTAReaderInputStream
extends InputStream {
    protected final boolean isLayerBStream;
    protected final boolean readStatusByte;
    private boolean statusSet;
    private byte status;
    private boolean suppressException;

    protected EXTDTAReaderInputStream(boolean bl, boolean bl2) {
        this.isLayerBStream = bl;
        this.readStatusByte = bl2;
    }

    private void setStatus(int n) {
        this.status = (byte)(n & 0xFF);
        this.statusSet = true;
    }

    public boolean isStatusSet() {
        return this.statusSet;
    }

    public byte getStatus() {
        if (!this.statusSet) {
            throw new IllegalStateException("status hasn't been set");
        }
        return this.status;
    }

    void setSuppressException(boolean bl) {
        this.suppressException = bl;
    }

    public boolean isLayerBStream() {
        return this.isLayerBStream;
    }

    protected void checkStatus(int n) throws IOException {
        this.setStatus(n);
        if (!this.suppressException && this.status != 127) {
            this.onClientSideStreamingError();
            EXTDTAReaderInputStream.throwEXTDTATransferException(n);
        }
    }

    protected abstract void onClientSideStreamingError();

    static void throwEXTDTATransferException(int n) throws IOException {
        switch (n) {
            case 1: {
                throw new IOException(MessageService.getTextMessage("I028"));
            }
            case 2: 
            case 4: {
                throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
            }
            case 127: {
                throw new IllegalStateException("throwEXTDTATransferException invoked with EXTDTA status byte STREAM_OK");
            }
        }
        throw new IOException("Invalid stream EXTDTA status code: " + n);
    }
}

