/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.sirius.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.marker.SiriusMarkerNavigationProviderSpec;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.viatra.addon.validation.core.api.IEntry;
import org.eclipse.viatra.addon.validation.core.api.IViolation;
import org.eclipse.viatra.addon.validation.core.listeners.ConstraintListener;
import org.eclipse.viatra.addon.validation.core.listeners.ViolationListener;

public class VGQLViolationListener
implements ConstraintListener,
ViolationListener {
    private final Logger logger;
    private final Map<IViolation, IMarker> markerMap = new HashMap<IViolation, IMarker>();
    private final IFile editorLocation;
    private final DiagramEditPart diagramEditPart;

    public VGQLViolationListener(DiagramEditPart diagramEditPart, IFile editorLocation, Logger logger) {
        this.diagramEditPart = diagramEditPart;
        this.editorLocation = Objects.requireNonNull(editorLocation);
        this.logger = logger;
    }

    public void violationAppeared(IViolation violation) {
        List keyNames = violation.getConstraint().getSpecification().getKeyNames();
        Map keyObjects = violation.getKeyObjects();
        for (String keyName : keyNames) {
            int statusSeverity;
            Object keyObject = keyObjects.get(keyName);
            if (!(keyObject instanceof EObject)) continue;
            EObject location = (EObject)keyObject;
            if (location.eResource() == null) break;
            View view = VGQLViolationListener.getCorrespondingView(location, this.diagramEditPart);
            switch (violation.getConstraint().getSpecification().getSeverity()) {
                case INFO: {
                    statusSeverity = 1;
                    break;
                }
                case WARNING: {
                    statusSeverity = 2;
                    break;
                }
                default: {
                    statusSeverity = 4;
                }
            }
            IMarker marker = VGQLViolationListener.addMarker(this.diagramEditPart.getViewer(), this.editorLocation, view, EMFCoreUtil.getQualifiedName((EObject)location, (boolean)true), violation.getMessage(), statusSeverity);
            this.markerMap.put(violation, marker);
            violation.addListener((ViolationListener)this);
            break;
        }
    }

    public void violationDisappeared(IViolation violation) {
        IMarker marker = this.markerMap.remove(violation);
        if (marker != null) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                this.logger.error((Object)"Could not delete marker!", (Throwable)e);
            }
        }
    }

    public void violationEntryAppeared(IViolation violation, IEntry entry) {
    }

    public void violationMessageUpdated(IViolation violation) {
        IMarker marker = this.markerMap.get(violation);
        if (marker != null) {
            try {
                marker.setAttribute("message", (Object)violation.getMessage());
            }
            catch (CoreException e) {
                this.logger.error((Object)"Error during marker update!", (Throwable)e);
            }
        }
    }

    public void violationEntryDisappeared(IViolation violation, IEntry entry) {
    }

    public void dispose() {
        for (IMarker marker : this.markerMap.values()) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                this.logger.error((Object)String.format("Exception occured when removing a marker on dispose: %s", e.getMessage()), (Throwable)e);
            }
        }
    }

    private static View getCorrespondingView(EObject element, DiagramEditPart diagramEditPart) {
        DSemanticDecorator dSemanticDecorator = VGQLViolationListener.getDSemanticDecorator(element, diagramEditPart);
        View view = null;
        if (dSemanticDecorator != null) {
            view = SiriusGMFHelper.getGmfView((DSemanticDecorator)dSemanticDecorator);
        }
        if (view == null) {
            view = diagramEditPart.getDiagramView();
        }
        return view;
    }

    private static DSemanticDecorator getDSemanticDecorator(EObject element, DiagramEditPart diagramEditPart) {
        DSemanticDecorator dSemanticDecorator = null;
        if (!(element instanceof DSemanticDecorator)) {
            Collection xrefs = new EObjectQuery(element).getInverseReferences(ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET);
            DDiagram dDiagram = (DDiagram)diagramEditPart.getDiagramView().getElement();
            for (EObject eObject : xrefs) {
                if (eObject != dDiagram && (!(eObject instanceof DSemanticDecorator) || !EcoreUtil.isAncestor((EObject)dDiagram, (EObject)eObject))) continue;
                dSemanticDecorator = (DSemanticDecorator)eObject;
                break;
            }
        } else {
            dSemanticDecorator = (DSemanticDecorator)element;
        }
        return dSemanticDecorator;
    }

    private static IMarker addMarker(EditPartViewer viewer, IFile target, View view, String location, String message, int statusSeverity) {
        String elementId = view.eResource().getURIFragment((EObject)view);
        String semanticURI = null;
        EObject ddiagramElement = view.getElement();
        if (ddiagramElement instanceof DSemanticDecorator) {
            EObject semanticElement = ((DSemanticDecorator)ddiagramElement).getTarget();
            semanticURI = EcoreUtil.getURI((EObject)semanticElement).toString();
        }
        Object object = viewer.getFocusEditPart().getModel();
        String diagramDescriptorUri = VGQLViolationListener.getDRepresentationDescriptorURIFromDiagram(object);
        return SiriusMarkerNavigationProviderSpec.addMarker((IFile)target, (String)elementId, (String)diagramDescriptorUri, (String)semanticURI, (String)location, (String)message, (int)statusSeverity);
    }

    private static String getDRepresentationDescriptorURIFromDiagram(Object object) {
        String diagramDescriptorUri = null;
        if (object instanceof Diagram) {
            Optional<DRepresentationDescriptor> optional = Optional.of((Diagram)object).map(View::getElement).filter(DDiagram.class::isInstance).map(d -> {
                DRepresentationQuery query = new DRepresentationQuery((DRepresentation)((DDiagram)d));
                return query.getRepresentationDescriptor();
            });
            if (optional.isPresent()) {
                URI uri = EcoreUtil.getURI((EObject)((EObject)optional.get()));
                diagramDescriptorUri = uri.toString();
            }
        }
        return diagramDescriptorUri;
    }
}

