/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.core.commands.Request;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IMemento;

public class RegisterGroupProxy
implements IModelProxyFactory,
IColumnPresentationFactory,
IElementContentProvider,
IElementMementoProvider {
    private IRegisterGroup[] fGroups;
    private final IStackFrame fFrame;
    private static final String HASH_CODE = "HASH_CODE";

    public RegisterGroupProxy(IStackFrame frame) throws DebugException {
        this.fFrame = frame;
        this.init(frame);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegisterGroupProxy) {
            return Arrays.equals(this.fGroups, ((RegisterGroupProxy)obj).fGroups);
        }
        return false;
    }

    public int hashCode() {
        int code = this.getClass().hashCode();
        IRegisterGroup[] iRegisterGroupArray = this.fGroups;
        int n = this.fGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisterGroup fGroup = iRegisterGroupArray[n2];
            code += fGroup.hashCode();
            ++n2;
        }
        return code;
    }

    private void init(IStackFrame frame) throws DebugException {
        this.fGroups = frame.getRegisterGroups();
    }

    protected IRegisterGroup[] getRegisterGroups() {
        return this.fGroups;
    }

    @Override
    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IModelProxyFactory factory = ViewerAdapterService.getModelProxyFactory(this.fFrame);
        if (factory != null) {
            return factory.createModelProxy(this.fFrame, context);
        }
        return null;
    }

    @Override
    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        IColumnPresentationFactory factory = ViewerAdapterService.getColumnPresentationFactory(this.fFrame);
        if (factory != null) {
            return factory.createColumnPresentation(context, this.fFrame);
        }
        return null;
    }

    @Override
    public String getColumnPresentationId(IPresentationContext context, Object element) {
        IColumnPresentationFactory factory = ViewerAdapterService.getColumnPresentationFactory(this.fFrame);
        if (factory != null) {
            return factory.getColumnPresentationId(context, this.fFrame);
        }
        return null;
    }

    @Override
    public void update(IChildrenCountUpdate[] updates) {
        IElementContentProvider provider = ViewerAdapterService.getContentProvider(this.fFrame);
        if (provider != null) {
            IChildrenCountUpdate[] others = new IChildrenCountUpdate[updates.length];
            int i = 0;
            while (i < updates.length) {
                others[i] = new CountUpdate(updates[i]);
                ++i;
            }
            provider.update(others);
        } else {
            this.cancelUpdates(updates);
        }
    }

    @Override
    public void update(IChildrenUpdate[] updates) {
        IElementContentProvider provider = ViewerAdapterService.getContentProvider(this.fFrame);
        if (provider != null) {
            IChildrenUpdate[] others = new IChildrenUpdate[updates.length];
            int i = 0;
            while (i < updates.length) {
                others[i] = new ChildrenUpdate(updates[i]);
                ++i;
            }
            provider.update(others);
        } else {
            this.cancelUpdates(updates);
        }
    }

    @Override
    public void update(IHasChildrenUpdate[] updates) {
        IElementContentProvider provider = ViewerAdapterService.getContentProvider(this.fFrame);
        if (provider != null) {
            IHasChildrenUpdate[] others = new IHasChildrenUpdate[updates.length];
            int i = 0;
            while (i < updates.length) {
                others[i] = new HasUpdate(updates[i]);
                ++i;
            }
            provider.update(others);
        } else {
            this.cancelUpdates(updates);
        }
    }

    private void cancelUpdates(IViewerUpdate[] updates) {
        IViewerUpdate[] iViewerUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IViewerUpdate update = iViewerUpdateArray[n2];
            update.setStatus(Status.CANCEL_STATUS);
            update.done();
            ++n2;
        }
    }

    @Override
    public void compareElements(IElementCompareRequest[] requests) {
        IElementMementoProvider provider = ViewerAdapterService.getMementoProvider(this.fFrame);
        if (provider != null) {
            ArrayList<ElementCompare> others = new ArrayList<ElementCompare>(requests.length);
            IElementCompareRequest[] iElementCompareRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                IElementCompareRequest request = iElementCompareRequestArray[n2];
                if (request.getElement().equals(this)) {
                    Integer integer = request.getMemento().getInteger(HASH_CODE);
                    if (integer != null) {
                        request.setEqual(integer.intValue() == this.hashCode());
                    } else {
                        request.setEqual(false);
                    }
                    request.done();
                } else {
                    others.add(new ElementCompare(request));
                }
                ++n2;
            }
            if (!others.isEmpty()) {
                provider.compareElements(others.toArray(new IElementCompareRequest[others.size()]));
            }
        } else {
            this.cancelUpdates(requests);
        }
    }

    @Override
    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoProvider provider = ViewerAdapterService.getMementoProvider(this.fFrame);
        if (provider != null) {
            ArrayList<MementoRequest> others = new ArrayList<MementoRequest>(requests.length);
            IElementMementoRequest[] iElementMementoRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                IElementMementoRequest request = iElementMementoRequestArray[n2];
                if (request.getElement().equals(this)) {
                    request.getMemento().putInteger(HASH_CODE, this.hashCode());
                    request.done();
                } else {
                    others.add(new MementoRequest(request));
                }
                ++n2;
            }
            if (!others.isEmpty()) {
                provider.encodeElements(others.toArray(new IElementMementoRequest[others.size()]));
            }
        } else {
            this.cancelUpdates(requests);
        }
    }

    private class ChildrenUpdate
    extends Update
    implements IChildrenUpdate {
        private final IChildrenUpdate fUpdate;

        ChildrenUpdate(IChildrenUpdate delegate) {
            super(delegate);
            this.fUpdate = delegate;
        }

        @Override
        public int getLength() {
            return this.fUpdate.getLength();
        }

        @Override
        public int getOffset() {
            return this.fUpdate.getOffset();
        }

        @Override
        public void setChild(Object child, int offset) {
            this.fUpdate.setChild(child, offset);
        }
    }

    private class CountUpdate
    extends Update
    implements IChildrenCountUpdate {
        private final IChildrenCountUpdate fUpdate;

        CountUpdate(IChildrenCountUpdate delegate) {
            super(delegate);
            this.fUpdate = delegate;
        }

        @Override
        public void setChildCount(int numChildren) {
            this.fUpdate.setChildCount(numChildren);
        }
    }

    private class ElementCompare
    extends MementoRequest
    implements IElementCompareRequest {
        private final IElementCompareRequest fRequest;

        ElementCompare(IElementCompareRequest request) {
            super(request);
            this.fRequest = request;
        }

        @Override
        public void setEqual(boolean equal) {
            this.fRequest.setEqual(equal);
        }
    }

    private class HasUpdate
    extends Update
    implements IHasChildrenUpdate {
        private final IHasChildrenUpdate fUpdate;

        HasUpdate(IHasChildrenUpdate delegate) {
            super(delegate);
            this.fUpdate = delegate;
        }

        @Override
        public void setHasChilren(boolean hasChildren) {
            this.fUpdate.setHasChilren(hasChildren);
        }
    }

    private class MementoRequest
    extends Update
    implements IElementMementoRequest {
        private final IElementMementoRequest fUpdate;

        MementoRequest(IElementMementoRequest request) {
            super(request);
            this.fUpdate = request;
        }

        @Override
        public IMemento getMemento() {
            return this.fUpdate.getMemento();
        }

        @Override
        public Object getElement() {
            return this.fUpdate.getElement();
        }

        @Override
        public TreePath getElementPath() {
            return this.fUpdate.getElementPath();
        }
    }

    private class Update
    extends Request
    implements IViewerUpdate {
        private final IViewerUpdate fViewerUpdate;

        Update(IViewerUpdate update) {
            this.fViewerUpdate = update;
        }

        @Override
        public Object getElement() {
            return RegisterGroupProxy.this.fFrame;
        }

        @Override
        public TreePath getElementPath() {
            return TreePath.EMPTY;
        }

        @Override
        public IPresentationContext getPresentationContext() {
            return this.fViewerUpdate.getPresentationContext();
        }

        public void done() {
            this.fViewerUpdate.setStatus(this.getStatus());
            this.fViewerUpdate.done();
        }

        @Override
        public Object getViewerInput() {
            return RegisterGroupProxy.this.fFrame;
        }
    }
}

