/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.ContentSourceCompletableFuture;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CharsetStringBuilder;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.thread.Invocable;

public class FormFields
extends ContentSourceCompletableFuture<Fields> {
    public static final String MAX_FIELDS_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormKeys";
    public static final String MAX_LENGTH_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormContentSize";
    public static final int MAX_FIELDS_DEFAULT = 1000;
    public static final int MAX_LENGTH_DEFAULT = 200000;
    private static final CompletableFuture<Fields> EMPTY = CompletableFuture.completedFuture(Fields.EMPTY);
    private final Fields _fields;
    private final CharsetStringBuilder _builder;
    private final int _maxFields;
    private final int _maxLength;
    private int _length;
    private String _name;
    private int _percent = 0;
    private byte _percentCode;

    public static Charset getFormEncodedCharset(Request request) {
        String cs;
        HttpConfiguration config = request.getConnectionMetaData().getHttpConfiguration();
        if (!config.getFormEncodedMethods().contains(request.getMethod())) {
            return null;
        }
        String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (request.getLength() == 0L || StringUtil.isBlank((String)contentType)) {
            return null;
        }
        String contentTypeWithoutCharset = MimeTypes.getContentTypeWithoutCharset((String)contentType);
        MimeTypes.Type type = (MimeTypes.Type)MimeTypes.CACHE.get(contentTypeWithoutCharset);
        if (type != null) {
            if (type != MimeTypes.Type.FORM_ENCODED) {
                return null;
            }
        } else {
            int semi = contentTypeWithoutCharset.indexOf(59);
            if (semi > 0) {
                contentTypeWithoutCharset = contentTypeWithoutCharset.substring(0, semi);
            }
            if (!MimeTypes.Type.FORM_ENCODED.is(contentTypeWithoutCharset.trim())) {
                return null;
            }
        }
        return StringUtil.isEmpty((String)(cs = MimeTypes.getCharsetFromContentType((String)contentType))) ? StandardCharsets.UTF_8 : Charset.forName(cs);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static void set(Request request, CompletableFuture<Fields> fields) {
        request.setAttribute(FormFields.class.getName(), fields);
    }

    public static void setFields(Request request, Fields fields) {
        request.setAttribute(FormFields.class.getName(), fields);
    }

    public static Fields getFields(Request request) {
        int maxFields = FormFields.getContextAttribute(request.getContext(), MAX_FIELDS_ATTRIBUTE, 1000);
        int maxLength = FormFields.getContextAttribute(request.getContext(), MAX_LENGTH_ATTRIBUTE, 200000);
        return FormFields.getFields(request, maxFields, maxLength);
    }

    public static Fields getFields(Request request, int maxFields, int maxLength) {
        Charset charset = FormFields.getFormEncodedCharset(request);
        return FormFields.from(request, Invocable.InvocationType.NON_BLOCKING, request, charset, maxFields, maxLength).join();
    }

    public static void onFields(Request request, Promise.Invocable<Fields> promise) {
        FormFields.onFields(request, FormFields.getFormEncodedCharset(request), promise);
    }

    public static void onFields(Request request, Charset charset, Promise.Invocable<Fields> promise) {
        int maxFields = FormFields.getContextAttribute(request.getContext(), MAX_FIELDS_ATTRIBUTE, 1000);
        int maxLength = FormFields.getContextAttribute(request.getContext(), MAX_LENGTH_ATTRIBUTE, 200000);
        FormFields.onFields(request, charset, maxFields, maxLength, promise);
    }

    public static void onFields(Request request, Charset charset, int maxFields, int maxLength, Promise.Invocable<Fields> promise) {
        FormFields.from(request, promise.getInvocationType(), request, charset, maxFields, maxLength).whenComplete((BiConsumer)promise);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> get(Request request) {
        Object attr = request.getAttribute(FormFields.class.getName());
        if (attr instanceof FormFields) {
            FormFields futureFormFields = (FormFields)((Object)attr);
            return futureFormFields;
        }
        if (attr instanceof Fields) {
            Fields fields = (Fields)attr;
            return CompletableFuture.completedFuture(fields);
        }
        return EMPTY;
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> from(Request request) {
        int maxFields = FormFields.getContextAttribute(request.getContext(), MAX_FIELDS_ATTRIBUTE, 1000);
        int maxLength = FormFields.getContextAttribute(request.getContext(), MAX_LENGTH_ATTRIBUTE, 200000);
        return FormFields.from(request, maxFields, maxLength);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> from(Request request, Charset charset) {
        int maxFields = FormFields.getContextAttribute(request.getContext(), MAX_FIELDS_ATTRIBUTE, 1000);
        int maxLength = FormFields.getContextAttribute(request.getContext(), MAX_LENGTH_ATTRIBUTE, 200000);
        return FormFields.from(request, charset, maxFields, maxLength);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> from(Request request, int maxFields, int maxLength) {
        return FormFields.from(request, FormFields.getFormEncodedCharset(request), maxFields, maxLength);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> from(Request request, Charset charset, int maxFields, int maxLength) {
        return FormFields.from(request, Invocable.InvocationType.NON_BLOCKING, request, charset, maxFields, maxLength);
    }

    static CompletableFuture<Fields> from(Content.Source source, Invocable.InvocationType invocationType, Attributes attributes, Charset charset, int maxFields, int maxLength) {
        Object attr = attributes.getAttribute(FormFields.class.getName());
        if (attr instanceof FormFields) {
            FormFields futureFormFields = (FormFields)((Object)attr);
            return futureFormFields;
        }
        if (attr instanceof Fields) {
            Fields fields = (Fields)attr;
            return CompletableFuture.completedFuture(fields);
        }
        if (charset == null) {
            return EMPTY;
        }
        FormFields futureFormFields = new FormFields(source, invocationType, charset, maxFields, maxLength);
        attributes.setAttribute(FormFields.class.getName(), (Object)futureFormFields);
        futureFormFields.parse();
        return futureFormFields;
    }

    private static int getContextAttribute(Context context, String attribute, int defValue) {
        Object value = context.getAttribute(attribute);
        if (value == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException x) {
            return defValue;
        }
    }

    private FormFields(Content.Source source, Invocable.InvocationType invocationType, Charset charset, int maxFields, int maxSize) {
        super(source, invocationType);
        this._maxFields = maxFields;
        this._maxLength = maxSize;
        this._builder = CharsetStringBuilder.forCharset((Charset)charset);
        this._fields = new Fields(true);
    }

    protected Fields parse(Content.Chunk chunk) throws CharacterCodingException {
        ByteBuffer buffer = chunk.getByteBuffer();
        block15: while (BufferUtil.hasContent((ByteBuffer)buffer)) {
            byte b = buffer.get();
            switch (this._percent) {
                case 1: {
                    this._percentCode = b;
                    ++this._percent;
                    continue block15;
                }
                case 2: {
                    this._percent = 0;
                    this._builder.append(UrlEncoded.decodeHexByte((char)((char)this._percentCode), (char)((char)b)));
                    continue block15;
                }
            }
            if (this._name == null) {
                switch (b) {
                    case 38: {
                        String name = this._builder.build();
                        this.checkMaxLength(name);
                        this.onNewField(name, "");
                        continue block15;
                    }
                    case 61: {
                        this._name = this._builder.build();
                        this.checkMaxLength(this._name);
                        continue block15;
                    }
                    case 43: {
                        this._builder.append(' ');
                        continue block15;
                    }
                    case 37: {
                        ++this._percent;
                        continue block15;
                    }
                }
                this._builder.append(b);
                continue;
            }
            switch (b) {
                case 38: {
                    String value = this._builder.build();
                    this.checkMaxLength(value);
                    this.onNewField(this._name, value);
                    this._name = null;
                    continue block15;
                }
                case 43: {
                    this._builder.append(' ');
                    continue block15;
                }
                case 37: {
                    ++this._percent;
                    continue block15;
                }
            }
            this._builder.append(b);
        }
        if (!chunk.isLast()) {
            return null;
        }
        if (this._percent > 0) {
            throw new IllegalStateException("invalid percent encoding");
        }
        String value = this._builder.build();
        if (this._name == null) {
            if (!value.isEmpty()) {
                this.checkMaxLength(value);
                this.onNewField(value, "");
            }
            return this._fields;
        }
        this.checkMaxLength(value);
        this.onNewField(this._name, value);
        return this._fields;
    }

    private void checkMaxLength(String nameOrValue) {
        if (this._maxLength >= 0) {
            this._length += nameOrValue.length();
            if (this._length > this._maxLength) {
                throw new IllegalStateException("form too large > " + this._maxLength);
            }
        }
    }

    private void onNewField(String name, String value) {
        Fields.Field field = new Fields.Field(name, value);
        this._fields.add(field);
        if (this._maxFields >= 0 && this._fields.getSize() > this._maxFields) {
            throw new IllegalStateException("form with too many fields > " + this._maxFields);
        }
    }
}

