/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart.ActionsChartMultiViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;

public class MouseDragZoomProvider
extends TmfBaseProvider
implements MouseListener,
MouseMoveListener,
ICustomPaintListener {
    private long fStartTime;
    private long fEndTime;
    private boolean fIsUpdate;
    private ActionsChartMultiViewer fChartViewer;

    public MouseDragZoomProvider(ActionsChartMultiViewer tmfChartViewer) {
        super((ITmfChartTimeProvider)tmfChartViewer.getChartViewer());
        this.fChartViewer = tmfChartViewer;
    }

    public void refresh() {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L && e.button == 3) {
            IAxis xAxis = this.getXAxis();
            this.fEndTime = this.fStartTime = this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x));
            this.fIsUpdate = true;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.fIsUpdate && this.fStartTime != this.fEndTime) {
            if (this.fStartTime > this.fEndTime) {
                long tmp = this.fStartTime;
                this.fStartTime = this.fEndTime;
                this.fEndTime = tmp;
            }
            ITmfChartTimeProvider viewer = this.getChartViewer();
            viewer.updateWindow(this.fStartTime + viewer.getTimeOffset(), this.fEndTime + viewer.getTimeOffset());
        } else if (e.button == 3) {
            this.fChartViewer.showMenu();
        }
        if (this.fIsUpdate) {
            this.redraw();
        }
        this.fIsUpdate = false;
    }

    public void mouseMove(MouseEvent e) {
        if (this.fIsUpdate) {
            ITmfChartTimeProvider viewer = this.getChartViewer();
            this.fStartTime = viewer.getWindowStartTime();
            this.fEndTime = viewer.getWindowEndTime();
            if (viewer instanceof TmfXYChartViewer) {
                IAxis xAxis = this.getXAxis();
                long cursorTime = this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x));
                TmfXYChartViewer xyChartViewer = (TmfXYChartViewer)viewer;
                xyChartViewer.updateStatusLine(this.fStartTime, this.fEndTime, cursorTime);
            }
            this.redraw();
        }
    }

    public void paintControl(PaintEvent e) {
        if (this.fIsUpdate && this.fStartTime != this.fEndTime) {
            IAxis xAxis = this.getXAxis();
            int startX = xAxis.getPixelCoordinate((double)this.fStartTime);
            int endX = xAxis.getPixelCoordinate((double)this.fEndTime);
            e.gc.setBackground(MouseDragZoomProvider.getDisplay().getSystemColor(34));
            if (this.fStartTime < this.fEndTime) {
                e.gc.fillRectangle(startX, 0, endX - startX, e.height);
            } else {
                e.gc.fillRectangle(endX, 0, startX - endX, e.height);
            }
            e.gc.drawLine(startX, 0, startX, e.height);
            e.gc.drawLine(endX, 0, endX, e.height);
        }
    }

    public boolean drawBehindSeries() {
        return true;
    }

    protected static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

