/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.junit.Assert;

public class ClasspathHelpers {
    public static final String JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER.*";
    public static final String M2E_CONTAINER = "org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER";

    public static IClasspathEntry getClasspathEntry(IClasspathEntry[] cp, IPath path) {
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (path.equals((Object)cpe.getPath())) {
                return cpe;
            }
            ++n2;
        }
        Assert.fail((String)("Missing classpath entry " + String.valueOf(path)));
        return null;
    }

    public static IClasspathEntry getClasspathEntry(IClasspathEntry[] cp, String path) {
        return ClasspathHelpers.getClasspathEntry(cp, IPath.fromOSString((String)path));
    }

    public static void assertClasspathEntry(IClasspathEntry[] cp, String ... segments) {
        int count = 0;
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (ClasspathHelpers.startsWith(cpe.getPath(), segments)) {
                ++count;
            }
            ++n2;
        }
        Assert.assertEquals((String)("Unexpected classpath with prefix " + Arrays.toString(segments)), (long)1L, (long)count);
    }

    private static boolean startsWith(IPath path, String[] segments) {
        if (path.segmentCount() < segments.length) {
            return false;
        }
        int i = 0;
        while (i < segments.length) {
            if (!segments[i].equals(path.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void assertClasspathEntry(IClasspathEntry[] cp, IPath path) {
        int count = 0;
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.getPath().equals((Object)path)) {
                ++count;
            }
            ++n2;
        }
        Assert.assertEquals((String)("Number of classpath entries with path " + String.valueOf(path)), (long)1L, (long)count);
    }

    public static Map<String, IClasspathEntry> assertClasspath(String[] expectedPathPatterns, IClasspathEntry[] entries) {
        LinkedHashMap<String, IClasspathEntry> matchingEntry = new LinkedHashMap<String, IClasspathEntry>(expectedPathPatterns.length);
        LinkedHashSet<String> unmatched = new LinkedHashSet<String>(Arrays.asList(expectedPathPatterns));
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            String path = entry.getPath().toPortableString();
            String[] stringArray = expectedPathPatterns;
            int n3 = expectedPathPatterns.length;
            int n4 = 0;
            while (n4 < n3) {
                String pattern = stringArray[n4];
                if (Pattern.matches(pattern, path)) {
                    matchingEntry.put(pattern, entry);
                    unmatched.remove(pattern);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (unmatched.isEmpty()) {
            return matchingEntry;
        }
        StringBuilder sb_expected = new StringBuilder();
        for (String expected : unmatched) {
            sb_expected.append(expected).append("\n");
        }
        StringBuilder sb_actual = new StringBuilder();
        IClasspathEntry[] iClasspathEntryArray2 = entries;
        int n5 = entries.length;
        int n6 = 0;
        while (n6 < n5) {
            IClasspathEntry cpe = iClasspathEntryArray2[n6];
            sb_actual.append(cpe.getPath().toPortableString()).append("\n");
            ++n6;
        }
        Assert.fail((String)("The following entries could not be matched to the classpath: \n" + sb_expected.toString() + "\nThe actual classpath is:\n" + sb_actual.toString()));
        return Map.of();
    }

    public static Map<String, IClasspathEntry> assertClasspath(IProject project, String ... expectedPatterns) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        Assert.assertNotNull((String)"Is a Java project", (Object)javaProject);
        return ClasspathHelpers.assertClasspath(expectedPatterns, javaProject.getRawClasspath());
    }

    public static IClasspathAttribute getClasspathAttribute(IClasspathEntry entry, String attributeName) {
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute a = iClasspathAttributeArray[n2];
            if (attributeName.equals(a.getName())) {
                return a;
            }
            ++n2;
        }
        return null;
    }
}

