/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.problems.ApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.search.MissingRefReportConverter;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseScanParser;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MissingRefParser
extends UseScanParser {
    static final FileFilter filter = pathname -> pathname.isFile() && pathname.getName().endsWith(".xml");

    MissingRefParser() {
    }

    public void parse(String xmlLocation, MissingRefReportConverter.MissingRefVisitor visitor) throws Exception {
        if (xmlLocation == null) {
            throw new Exception(SearchMessages.missing_xml_files_location);
        }
        File reportsRoot = new File(xmlLocation);
        if (!reportsRoot.exists() || !reportsRoot.isDirectory()) {
            throw new Exception(NLS.bind((String)SearchMessages.invalid_directory_name, (Object)xmlLocation));
        }
        File[] components = this.getDirectories(reportsRoot);
        components = this.sort(components);
        visitor.visitScan();
        SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
        File[] fileArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String[] idv;
            IComponentDescriptor targetComponent;
            File component = fileArray[n2];
            if (component.isDirectory() && visitor.visitComponent(targetComponent = Factory.componentDescriptor((idv = this.getIdVersion(component.getName()))[0], idv[1]))) {
                File[] xmlfiles = Util.getAllFiles(component, filter);
                if (xmlfiles != null && xmlfiles.length > 0) {
                    File[] fileArray2 = xmlfiles = this.sort(xmlfiles);
                    int n3 = xmlfiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File xmlfile = fileArray2[n4];
                        try {
                            MissingRefProblemHandler handler = new MissingRefProblemHandler();
                            parser.parse(xmlfile, (DefaultHandler)handler);
                            List<IApiProblem> apiProblems = handler.getProblems();
                            visitor.addToCurrentReport(apiProblems);
                        }
                        catch (IOException | SAXException e) {
                            ApiPlugin.log("Failed to load problems from " + String.valueOf(xmlfile), e);
                        }
                        ++n4;
                    }
                }
                visitor.endVisitComponent();
            }
            ++n2;
        }
    }

    static class MissingRefProblemHandler
    extends DefaultHandler {
        List<IApiProblem> problems = new ArrayList<IApiProblem>();
        private String typename;
        private int linenumber;
        private int charstart;
        private int charend;
        private int id;
        private final List<String> messageargs = new ArrayList<String>();
        private final Map<String, String> extraargs = new HashMap<String, String>();

        MissingRefProblemHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("api_problem".equalsIgnoreCase(qName)) {
                this.typename = attributes.getValue("typeName");
                this.linenumber = Integer.parseInt(attributes.getValue("linenumber"));
                this.charstart = Integer.parseInt(attributes.getValue("charstart"));
                this.charend = Integer.parseInt(attributes.getValue("charend"));
                this.id = Integer.parseInt(attributes.getValue("id"));
            } else if ("message_arguments".equalsIgnoreCase(qName)) {
                this.messageargs.clear();
            } else if ("message_argument".equalsIgnoreCase(qName)) {
                this.messageargs.add(attributes.getValue("value"));
            } else if ("extra_arguments".equalsIgnoreCase(qName)) {
                this.extraargs.clear();
            } else if ("extra_argument".equalsIgnoreCase(qName)) {
                this.extraargs.put(attributes.getValue("id"), attributes.getValue("value"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("api_problem".equalsIgnoreCase(qName)) {
                String[] argumentids = new String[this.extraargs.size()];
                Object[] arguments = new Object[this.extraargs.size()];
                int i = 0;
                for (Map.Entry<String, String> entry : this.extraargs.entrySet()) {
                    argumentids[i] = entry.getKey();
                    arguments[i] = entry.getValue();
                }
                ApiProblem problem = new ApiProblem(null, this.typename, this.messageargs.toArray(new String[this.messageargs.size()]), argumentids, arguments, this.linenumber, this.charstart, this.charend, this.id);
                this.problems.add(problem);
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        public List<IApiProblem> getProblems() {
            return this.problems;
        }
    }
}

