/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.buildship.core.internal.configuration.GradleArguments;
import org.eclipse.buildship.core.internal.gradle.GradleProgressAttributes;
import org.eclipse.buildship.core.internal.util.gradle.CompatProjectConnection;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.IntermediateResultHandler;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.model.build.BuildEnvironment;

public final class IdeAttachedProjectConnection
implements ProjectConnection {
    private final ProjectConnection delegate;
    private final GradleArguments gradleArguments;
    private final GradleProgressAttributes progressAttributes;

    private IdeAttachedProjectConnection(ProjectConnection connection, GradleArguments gradleArguments, GradleProgressAttributes progressAttributes) {
        this.delegate = connection;
        this.gradleArguments = gradleArguments;
        this.progressAttributes = progressAttributes;
    }

    public BuildLauncher newBuild() {
        return this.configureOperation(this.delegate.newBuild());
    }

    public TestLauncher newTestLauncher() {
        return this.configureOperation(this.delegate.newTestLauncher());
    }

    public <T> ModelBuilder<T> model(Class<T> modelType) {
        return this.configureOperation(this.delegate.model(modelType));
    }

    public <T> BuildActionExecuter<T> action(BuildAction<T> buildAction) {
        return this.configureOperation(this.delegate.action(buildAction));
    }

    private <T extends LongRunningOperation> T configureOperation(T operation) {
        BuildEnvironment buildEnvironment = (BuildEnvironment)this.delegate.getModel(BuildEnvironment.class);
        this.gradleArguments.applyTo(operation, buildEnvironment);
        this.progressAttributes.applyTo(operation);
        return operation;
    }

    public void close() {
        this.delegate.close();
    }

    public BuildActionExecuter.Builder action() {
        return new IdeAttachedBuilder(this.delegate.action());
    }

    public <T> T getModel(Class<T> modelType) throws GradleConnectionException, IllegalStateException {
        return (T)this.model(modelType).get();
    }

    public <T> void getModel(Class<T> modelType, ResultHandler<? super T> handler) throws IllegalStateException {
        this.model(modelType).get(handler);
    }

    public void notifyDaemonsAboutChangedPaths(List<Path> changedPaths) {
        this.delegate.notifyDaemonsAboutChangedPaths(changedPaths);
    }

    public static ProjectConnection newInstance(CancellationTokenSource tokenSource, GradleArguments gradleArguments, InternalGradleBuild gradleBuild, IProgressMonitor monitor) {
        GradleConnector connector = GradleConnector.newConnector();
        gradleArguments.applyTo(connector);
        CompatProjectConnection connection = new CompatProjectConnection(connector.connect());
        GradleProgressAttributes progressAttributes = GradleProgressAttributes.builder(tokenSource, gradleBuild, monitor).forBackgroundProcess().withFullProgress().build();
        return new IdeAttachedProjectConnection(connection, gradleArguments, progressAttributes);
    }

    private class IdeAttachedBuilder
    implements BuildActionExecuter.Builder {
        private final BuildActionExecuter.Builder action;

        IdeAttachedBuilder(BuildActionExecuter.Builder action) {
            this.action = action;
        }

        public <T> BuildActionExecuter.Builder projectsLoaded(BuildAction<T> buildAction, IntermediateResultHandler<? super T> handler) throws IllegalArgumentException {
            this.action.projectsLoaded(buildAction, handler);
            return this;
        }

        public <T> BuildActionExecuter.Builder buildFinished(BuildAction<T> buildAction, IntermediateResultHandler<? super T> handler) throws IllegalArgumentException {
            this.action.buildFinished(buildAction, handler);
            return this;
        }

        public BuildActionExecuter<Void> build() {
            return IdeAttachedProjectConnection.this.configureOperation(this.action.build());
        }
    }
}

