/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethodTemplate;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.Template;

public class MethodTemplate
extends Method
implements IMethodTemplate {
    protected Template fTemplate;

    public MethodTemplate(ICElement parent, String name) {
        super(parent, name, 91);
        this.fTemplate = new Template(name);
    }

    @Override
    public String[] getTemplateParameterTypes() {
        return this.fTemplate.getTemplateParameterTypes();
    }

    @Override
    public String[] getTemplateArguments() {
        return this.fTemplate.getTemplateArguments();
    }

    public void setTemplateParameterTypes(String[] templateParameterTypes) {
        this.fTemplate.setTemplateInfo(templateParameterTypes, null);
    }

    @Override
    public int getNumberOfTemplateParameters() {
        return this.fTemplate.getNumberOfTemplateParameters();
    }

    @Override
    public String getTemplateSignature() throws CModelException {
        StringBuilder sig = new StringBuilder(this.fTemplate.getTemplateSignature());
        sig.append(this.getParameterClause());
        if (this.isConst()) {
            sig.append(" const");
        }
        if (this.isVolatile()) {
            sig.append(" volatile");
        }
        if (this.getReturnType() != null && this.getReturnType().length() > 0) {
            sig.append(" : ");
            sig.append(this.getReturnType());
        }
        return sig.toString();
    }
}

