/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.console;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshOperation;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.console.BuildConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

public class BuildConsoleManager {
    private final Map<IBuild, BuildConsole> consoleByBuild;
    private final IConsoleManager consoleManager;
    private final IConsoleListener listener = new IConsoleListener(){

        public void consolesAdded(IConsole[] consoles) {
        }

        public void consolesRemoved(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                Object build;
                IConsole console = iConsoleArray[n2];
                if ("org.eclipse.mylyn.builds.ui.console.BuildConsole".equals(console.getType()) && (build = ((MessageConsole)console).getAttribute("org.eclipse.mylyn.builds.ui.console.build")) instanceof IBuild) {
                    BuildConsoleManager.this.disposeConsole((IBuild)build);
                }
                ++n2;
            }
        }
    };

    public BuildConsoleManager() {
        this.consoleByBuild = new HashMap<IBuild, BuildConsole>();
        this.consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        this.consoleManager.addConsoleListener(this.listener);
    }

    protected void disposeConsole(IBuild build) {
        BuildConsole console = this.consoleByBuild.get(build);
        if (console != null) {
            console.close();
            this.consoleByBuild.remove(build);
        }
    }

    public BuildConsole showConsole(IBuild build) {
        Assert.isNotNull((Object)build);
        BuildConsole console = this.consoleByBuild.get(build);
        if (console == null) {
            console = new BuildConsole(this.consoleManager, BuildsUiInternal.getModel(), build);
            this.consoleByBuild.put(build, console);
        }
        console.show();
        return console;
    }

    public void showConsole(final IBuildPlan plan) {
        if (plan.getLastBuild() != null) {
            this.showConsole(plan.getLastBuild());
        } else {
            RefreshOperation operation = BuildsUiInternal.getFactory().getRefreshOperation((IBuildElement)plan);
            operation.addOperationChangeListener(new OperationChangeListener(){

                public void done(OperationChangeEvent event) {
                    event.getOperation().getService().getRealm().asyncExec(() -> {
                        if (plan.getLastBuild() != null) {
                            BuildConsoleManager.this.showConsole(plan.getLastBuild());
                        }
                    });
                }
            });
            operation.execute();
        }
    }

    public void stop() {
        this.consoleManager.removeConsoleListener(this.listener);
    }
}

