/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.quickfix;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.arrowtype.DeprecatedShape;
import org.eclipse.gef.dot.internal.language.arrowtype.PrimitiveShape;
import org.eclipse.gef.dot.internal.language.clustermode.ClusterMode;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.dir.DirType;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotFactory;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsSubgraph;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.layout.Layout;
import org.eclipse.gef.dot.internal.language.outputmode.OutputMode;
import org.eclipse.gef.dot.internal.language.pagedir.Pagedir;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.ranktype.RankType;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedNodeShape;
import org.eclipse.gef.dot.internal.language.style.ClusterStyle;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.quickfix.DotHtmlLabelQuickfixDelegator;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IMultiModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class DotQuickfixProvider
extends DefaultQuickfixProvider {
    private static final String DELETE_IMAGE = "delete.png";

    @Fix(value="invalid-edge-operator")
    public void fixInvalidEdgeOperator(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        if (issueData != null && issueData.length > 0) {
            String invalidEdgeOperator = issueData[0];
            EdgeOp validEdgeOperator = invalidEdgeOperator.equals(EdgeOp.DIRECTED.toString()) ? EdgeOp.UNDIRECTED : EdgeOp.DIRECTED;
            this.provideMultiQuickfix(invalidEdgeOperator, validEdgeOperator.toString(), "edge operator", issue, acceptor, (IMultiModification<EObject>)((IMultiModification)element -> {
                EdgeRhsNode edge;
                if (element instanceof EdgeRhsNode) {
                    edge = (EdgeRhsNode)element;
                    edge.setOp(validEdgeOperator);
                }
                if (element instanceof EdgeRhsSubgraph) {
                    edge = (EdgeRhsSubgraph)element;
                    edge.setOp(validEdgeOperator);
                }
            }));
        }
    }

    @Fix(value="redundant-attribute")
    public void fixRedundantAttribute(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() == null || issue.getData().length == 0) {
            return;
        }
        String attributeName = issue.getData()[0];
        String label = "Remove '" + attributeName + "' attribute.";
        String description = "Remove the redundant '" + attributeName + "' attribute.";
        ISemanticModification semanticModification = (element, context) -> EcoreUtil.remove((EObject)element);
        acceptor.accept(issue, label, description, DELETE_IMAGE, semanticModification);
    }

    @Fix(value="arrowhead")
    public void fixArrowheadAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.fixArrowType(issue, "edge arrowhead", acceptor);
    }

    @Fix(value="arrowtail")
    public void fixArrowtailAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        this.fixArrowType(issue, "edge arrowtail", acceptor);
    }

    @Fix(value="clusterrank")
    public void fixClusterRankAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String invalidValue = issue.getData()[0];
        this.provideQuickfixes(invalidValue, ClusterMode.values(), "graph clusterMode", issue, acceptor);
    }

    @Fix(value="colorscheme")
    public void fixColorschemeAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String invalidValue = issue.getData()[0];
        this.provideQuickfixes(invalidValue, DotColors.getColorSchemes(), "colorscheme", issue, acceptor);
    }

    @Fix(value="dir")
    public void fixDirAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String invalidValue = issue.getData()[0];
        this.provideQuickfixes(invalidValue, DirType.values(), "edge dir", issue, acceptor);
    }

    @Fix(value="label")
    public void fixHtmlLabelAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] data = issue.getData();
        if (data == null || data.length < 4) {
            return;
        }
        String htmlLabelIssueCode = data[0];
        String htmlLabelUriToProblem = data[1];
        Issue.IssueImpl htmlLabelIssue = new Issue.IssueImpl();
        htmlLabelIssue.setCode(htmlLabelIssueCode);
        htmlLabelIssue.setData(data);
        htmlLabelIssue.setUriToProblem(URI.createURI((String)htmlLabelUriToProblem));
        new DotHtmlLabelQuickfixDelegator().provideQuickfixes(issue, (Issue)htmlLabelIssue, acceptor);
    }

    @Fix(value="layout")
    public void fixLayoutAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String invalidValue = issue.getData()[0];
        this.provideQuickfixes(invalidValue, Layout.values(), "graph layout", issue, acceptor);
    }

    @Fix(value="outputorder")
    public void fixOutputOrderAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String invalidValue = issue.getData()[0];
        this.provideQuickfixes(invalidValue, OutputMode.values(), "graph outputMode", issue, acceptor);
    }

    @Fix(value="pagedir")
    public void fixPagedirAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String invalidValue = issue.getData()[0];
        this.provideQuickfixes(invalidValue, Pagedir.values(), "graph pagedir", issue, acceptor);
    }

    @Fix(value="rank")
    public void fixRankAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String invalidValue = issue.getData()[0];
        this.provideQuickfixes(invalidValue, RankType.values(), "subgraph rankType", issue, acceptor);
    }

    @Fix(value="rankdir")
    public void fixRankdirAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String invalidValue = issue.getData()[0];
        this.provideQuickfixes(invalidValue, Rankdir.values(), "graph rankdir", issue, acceptor);
    }

    @Fix(value="shape")
    public void fixShapeAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String invalidValue = issue.getData()[0];
        this.provideQuickfixes(invalidValue, PolygonBasedNodeShape.VALUES, "node shape", issue, acceptor);
        this.provideQuickfixes(invalidValue, RecordBasedNodeShape.VALUES, "node shape", issue, acceptor);
    }

    @Fix(value="style")
    public void fixStyleAttributeValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String issueCode;
        String[] issueData = issue.getData();
        if (issueData == null || issueData.length < 2) {
            return;
        }
        switch (issueCode = issueData[0]) {
            case "deprecated_style_item": {
                this.provideQuickfixesForDeprecatedStyleItem(issue, acceptor);
                break;
            }
            case "duplicated_style_item": {
                this.provideQuickfixesForDuplicatedStyleItem(issue, acceptor);
                break;
            }
            case "invalid_style_item": {
                this.provideQuickfixesForInvalidStyleItem(issue, acceptor);
            }
            default: {
                return;
            }
        }
    }

    private void fixArrowType(Issue issue, String suffix, IssueResolutionAcceptor acceptor) {
        String issueCode;
        String[] issueData = issue.getData();
        if (issueData == null || issueData.length < 1) {
            return;
        }
        switch (issueCode = issueData[0]) {
            case "deprecated_arrow_shape": {
                this.provideQuickfixesForDeprecatedArrowShape(issue, suffix, acceptor);
                break;
            }
            case "invalid_arrow_shape_modifier": {
                this.provideQuickfixesInvalidArrowShapeModifier(issue, suffix, acceptor);
                break;
            }
            case "invalid_arrow_shape_none_is_the_last": {
                this.provideQuickfixesInvalidArrowShapeNoneIsTheLast(issue, suffix, acceptor);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void provideQuickfixesForDeprecatedArrowShape(Issue issue, String suffix, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        String deprecatedShapeString = issueData[1];
        String validArrowShape = this.getValidArrowShape(deprecatedShapeString);
        if (validArrowShape != null) {
            this.provideQuickfixForMultipleAttributeValue(deprecatedShapeString, validArrowShape, suffix, issue, acceptor);
        }
    }

    private void provideQuickfixesInvalidArrowShapeModifier(Issue issue, String suffix, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        String modifier = issueData[1];
        final int modifierIndex = Integer.parseInt(issueData[2]);
        acceptor.accept(issue, "Remove the '" + modifier + "' modifier.", "Remove the invalid '" + modifier + "' modifier.", DELETE_IMAGE, (ISemanticModification)new ChangingDotAttributeValueSemanticModification(this){

            @Override
            public String getNewValue(String currentValue) {
                return new StringBuilder(currentValue).deleteCharAt(modifierIndex).toString();
            }
        });
    }

    private void provideQuickfixesInvalidArrowShapeNoneIsTheLast(Issue issue, String suffix, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove the 'none' arrow shape.", "Remove the last 'none' arrow shape.", DELETE_IMAGE, (ISemanticModification)new ChangingDotAttributeValueSemanticModification(this){

            @Override
            public String getNewValue(String currentValue) {
                return currentValue.substring(0, currentValue.lastIndexOf(PrimitiveShape.NONE.getName()));
            }
        });
    }

    private void provideQuickfixesForDeprecatedStyleItem(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        String styleItemName = issueData[1];
        final String penwidthValue = issueData.length > 2 ? issueData[2] : "";
        final String styleItem = String.valueOf(styleItemName) + (penwidthValue == "" ? "" : "(" + penwidthValue + ")");
        String label = "Replace '" + styleItem + "' with 'penwidth=" + penwidthValue + "'.";
        String description = "Use the 'penwidth' attribute instead of the deprecated '" + styleItemName + "' style.";
        ChangingDotAttributeValueSemanticModification semanticModification = new ChangingDotAttributeValueSemanticModification(this){
            private String newValue;

            @Override
            public void apply(EObject element, IModificationContext context) throws Exception {
                super.apply(element, context);
                EObject container = element.eContainer();
                if (this.newValue.isEmpty()) {
                    EcoreUtil.remove((EObject)element);
                }
                Attribute penwidthAttribute = DotFactory.eINSTANCE.createAttribute();
                penwidthAttribute.setName(ID.fromValue((String)"penwidth"));
                penwidthAttribute.setValue(ID.fromValue((String)penwidthValue, (ID.Type)ID.Type.QUOTED_STRING));
                if (container instanceof AttrList) {
                    AttrList attrList = (AttrList)container;
                    attrList.getAttributes().add((Object)penwidthAttribute);
                } else if (container instanceof Subgraph) {
                    Subgraph subgraph = (Subgraph)container;
                    subgraph.getStmts().add((Object)penwidthAttribute);
                }
            }

            @Override
            public String getNewValue(String currentValue) {
                this.newValue = currentValue.replace(styleItem, "").trim().replaceAll("^,", "").replaceAll(",$", "").replace(", ,", ",").trim();
                return this.newValue;
            }
        };
        acceptor.accept(issue, label, description, null, (ISemanticModification)semanticModification);
    }

    private void provideQuickfixesForDuplicatedStyleItem(Issue issue, IssueResolutionAcceptor acceptor) {
        final String styleItem = issue.getData()[1];
        String label = "Remove '" + styleItem + "' style attribute value.";
        String description = "Remove the redundant '" + styleItem + "' style attribute value.";
        ChangingDotAttributeValueSemanticModification semanticModification = new ChangingDotAttributeValueSemanticModification(this){

            @Override
            public String getNewValue(String currentValue) {
                return currentValue.replaceFirst(String.valueOf(styleItem) + ",", "").trim();
            }
        };
        acceptor.accept(issue, label, description, DELETE_IMAGE, (ISemanticModification)semanticModification);
    }

    private void provideQuickfixesForInvalidStyleItem(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        String invalidValue = issueData[1];
        DotAttributes.Context attributeContext = DotAttributes.Context.valueOf((String)issueData[2]);
        switch (attributeContext) {
            case GRAPH: 
            case SUBGRAPH: 
            case CLUSTER: {
                this.provideQuickfixesForMultipleAttributeValue(invalidValue, ClusterStyle.VALUES, "graph style", issue, acceptor);
                break;
            }
            case NODE: {
                this.provideQuickfixesForMultipleAttributeValue(invalidValue, NodeStyle.VALUES, "node style", issue, acceptor);
                break;
            }
            case EDGE: {
                this.provideQuickfixesForMultipleAttributeValue(invalidValue, EdgeStyle.VALUES, "edge style", issue, acceptor);
                break;
            }
        }
    }

    private String getValidArrowShape(String deprecatedShapeString) {
        DeprecatedShape deprecatedShape = DeprecatedShape.get((String)deprecatedShapeString);
        if (deprecatedShape == null) {
            return null;
        }
        switch (deprecatedShape) {
            case EDIAMOND: {
                return "odiamond";
            }
            case OPEN: {
                return "vee";
            }
            case HALFOPEN: {
                return "lvee";
            }
            case EMPTY: {
                return "onormal";
            }
            case INVEMPTY: {
                return "oinv";
            }
        }
        return null;
    }

    private void provideQuickfixesForMultipleAttributeValue(String invalidValue, List<?> validValues, String suffix, Issue issue, IssueResolutionAcceptor acceptor) {
        for (Object validValue : validValues) {
            this.provideQuickfixForMultipleAttributeValue(invalidValue, validValue.toString(), suffix, issue, acceptor);
        }
    }

    private void provideQuickfixForMultipleAttributeValue(final String invalidValue, final String validValue, String suffix, Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfix(invalidValue, validValue, suffix, issue, acceptor, new ChangingDotAttributeValueSemanticModification(this){

            @Override
            public String getNewValue(String currentValue) {
                return currentValue.replaceAll(invalidValue, validValue);
            }
        });
    }

    private void provideQuickfixes(String invalidValue, Object[] validValues, String suffix, Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfixes(invalidValue, Arrays.asList(validValues), suffix, issue, acceptor);
    }

    private void provideQuickfixes(String invalidValue, List<?> validValues, String suffix, Issue issue, IssueResolutionAcceptor acceptor) {
        for (Object validValue : validValues) {
            this.provideQuickfix(invalidValue, validValue.toString(), suffix, issue, acceptor);
        }
    }

    private void provideQuickfix(String invalidValue, final String validValue, String suffix, Issue issue, IssueResolutionAcceptor acceptor) {
        this.provideQuickfix(invalidValue, validValue, suffix, issue, acceptor, new ChangingDotAttributeValueSemanticModification(this){

            @Override
            public String getNewValue(String currentValue) {
                return validValue;
            }
        });
    }

    private void provideQuickfix(String invalidValue, String validValue, String suffix, Issue issue, IssueResolutionAcceptor acceptor, ISemanticModification semanticModification) {
        acceptor.accept(issue, "Replace '" + invalidValue + "' with '" + validValue + "'.", "Use valid '" + validValue + "' instead of invalid '" + invalidValue + "' " + suffix + ".", null, semanticModification);
    }

    private void provideMultiQuickfix(String invalidValue, String validValue, String suffix, Issue issue, IssueResolutionAcceptor acceptor, IMultiModification<EObject> multiModification) {
        acceptor.acceptMulti(issue, "Replace '" + invalidValue + "' with '" + validValue + "'.", "Use valid '" + validValue + "' instead of invalid '" + invalidValue + "' " + suffix + ".", null, multiModification);
    }

    private abstract class ChangingDotAttributeValueSemanticModification
    implements ISemanticModification {
        private ChangingDotAttributeValueSemanticModification() {
        }

        public void apply(EObject element, IModificationContext context) throws Exception {
            Attribute attribute = (Attribute)element;
            ID value = attribute.getValue();
            String currentValue = value.toValue();
            ID.Type type = value.getType();
            String newValue = this.getNewValue(currentValue);
            ID newValueAsID = ID.fromValue((String)newValue, (ID.Type)type);
            attribute.setValue(newValueAsID);
        }

        protected abstract String getNewValue(String var1);
    }
}

