/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime;

import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryEngine;
import org.eclipse.emf.common.util.Diagnostic;

public interface IQueryBuilderEngine
extends IQueryEngine {
    public AstResult build(String var1) throws AcceleoQueryEvaluationException;

    public static class AstResult {
        private final Expression ast;
        private final List<Error> errors;
        private final Map<Object, Integer> startPositions;
        private final Map<Object, Integer> endPositions;
        private Diagnostic diagnostic;

        public AstResult(Expression ast, Map<Object, Integer> startPositions, Map<Object, Integer> endPositions, List<Error> errors, Diagnostic diagnostic) {
            this.ast = ast;
            this.startPositions = startPositions;
            this.endPositions = endPositions;
            this.errors = errors;
            this.diagnostic = diagnostic;
        }

        public Expression getAst() {
            return this.ast;
        }

        public List<Error> getErrors() {
            return this.errors;
        }

        public int getStartPosition(Expression expression) {
            return this.getInternalStartPosition(expression);
        }

        public int getStartPosition(VariableDeclaration declaration) {
            return this.getInternalStartPosition(declaration);
        }

        public int getInternalStartPosition(Object object) {
            Integer position = this.startPositions.get(object);
            int res = position != null ? position : -1;
            return res;
        }

        public int getEndPosition(Expression expression) {
            return this.getInternalEndPosition(expression);
        }

        public int getEndPosition(VariableDeclaration declaration) {
            return this.getInternalEndPosition(declaration);
        }

        private int getInternalEndPosition(Object object) {
            Integer position = this.endPositions.get(object);
            int res = position != null ? position : -1;
            return res;
        }

        public Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        public AstResult subResult(Expression subAst) {
            assert (this.startPositions.containsKey(subAst) && this.endPositions.containsKey(subAst));
            return new AstResult(subAst, this.startPositions, this.endPositions, this.errors, this.diagnostic);
        }
    }
}

