/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.util.Strings;

public class JDTAwareEclipseResourceFileSystemAccess2
extends EclipseResourceFileSystemAccess2 {
    private static final Logger LOG = Logger.getLogger(JDTAwareEclipseResourceFileSystemAccess2.class);

    @Override
    @Deprecated
    protected void createFolder(IFolder folder) throws CoreException {
        super.createFolder(folder);
    }

    @Override
    protected void createContainer(IContainer container) throws CoreException {
        super.createContainer(container);
        this.addToSourceFolders(container);
    }

    protected void addToSourceFolders(IContainer container) throws JavaModelException {
        IJavaProject jp = JavaCore.create((IProject)container.getProject());
        if (jp.exists() && !jp.isOnClasspath((IResource)container)) {
            IClasspathEntry currentClasspathEntry;
            IPackageFragmentRoot packageFragmentRoot;
            if (this.getCurrentSource() != null && (packageFragmentRoot = jp.findPackageFragmentRoot(jp.getPath().append(this.getCurrentSource()))) != null && (currentClasspathEntry = packageFragmentRoot.getRawClasspathEntry()) != null) {
                this.insertClasspathEntry(container, currentClasspathEntry, jp);
                return;
            }
            this.addClasspathEntry(container, jp);
        }
    }

    private void insertClasspathEntry(IContainer folder, IClasspathEntry prototype, IJavaProject project) throws JavaModelException {
        IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath(), (IPath[])prototype.getInclusionPatterns(), (IPath[])prototype.getExclusionPatterns(), (IPath)prototype.getOutputLocation(), (IClasspathAttribute[])prototype.getExtraAttributes());
        IClasspathEntry[] classPath = project.getRawClasspath();
        IClasspathEntry[] newClassPath = new IClasspathEntry[classPath.length + 1];
        int i = 0;
        IClasspathEntry[] iClasspathEntryArray = classPath;
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            newClassPath[i++] = entry;
            if (entry.equals(prototype)) {
                newClassPath[i++] = newEntry;
            }
            ++n2;
        }
        if (i == newClassPath.length - 1 && newClassPath[i] == null) {
            LOG.warn((Object)("Cannot find classpath entry '" + String.valueOf(prototype) + "'"));
            newClassPath[i] = newEntry;
        }
        project.setRawClasspath(newClassPath, this.getMonitor());
    }

    private void addClasspathEntry(IContainer folder, IJavaProject project) throws JavaModelException {
        IClasspathEntry srcFolderClasspathEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath());
        IClasspathEntry[] classPath = project.getRawClasspath();
        IClasspathEntry[] newClassPath = new IClasspathEntry[classPath.length + 1];
        System.arraycopy(classPath, 0, newClassPath, 0, classPath.length);
        newClassPath[newClassPath.length - 1] = srcFolderClasspathEntry;
        project.setRawClasspath(newClassPath, this.getMonitor());
    }

    @Override
    public void flushSourceTraces(String generatorName) throws CoreException {
        Multimap<SourceRelativeURI, IPath> sourceTraces = this.getSourceTraces();
        if (sourceTraces != null) {
            Set keys = sourceTraces.keySet();
            String source = this.getCurrentSource();
            IProject container = Strings.isEmpty((String)source) ? this.getProject() : this.getProject().getFolder(source);
            for (SourceRelativeURI uri : keys) {
                if (uri == null || source == null) continue;
                Collection paths = sourceTraces.get((Object)uri);
                IFile sourceFile = container.getFile((IPath)new Path(uri.getURI().path()));
                if (!sourceFile.exists()) continue;
                IPath[] tracePathArray = paths.toArray(new IPath[paths.size()]);
                this.getTraceMarkers().installMarker(sourceFile, generatorName, tracePathArray);
            }
        }
        this.resetSourceTraces();
    }
}

