/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.model.impl;

import com.google.common.base.Strings;
import org.eclipse.tea.core.annotations.TaskChainMenuEntry;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.internal.model.iface.TaskingItem;
import org.eclipse.tea.core.services.TaskChain;
import org.osgi.framework.FrameworkUtil;

public class TaskingItemImpl
implements TaskingItem {
    private final TaskChain chain;

    public TaskingItemImpl(TaskChain chain) {
        this.chain = chain;
    }

    @Override
    public TaskChain getChain() {
        return this.chain;
    }

    @Override
    public String getIconBundle() {
        return FrameworkUtil.getBundle(this.chain.getClass()).getSymbolicName();
    }

    @Override
    public String getIconPath() {
        TaskChainMenuEntry entry = this.chain.getClass().getAnnotation(TaskChainMenuEntry.class);
        if (entry == null || Strings.isNullOrEmpty((String)entry.icon())) {
            return null;
        }
        return entry.icon();
    }

    @Override
    public String getLabel() {
        return TaskingModel.getTaskChainName(this.chain);
    }

    @Override
    public boolean matchesId(String id) {
        if (id.equals(this.chain.getClass().getName())) {
            return true;
        }
        TaskChain.TaskChainId tcid = this.chain.getClass().getAnnotation(TaskChain.TaskChainId.class);
        if (tcid == null) {
            return false;
        }
        String[] stringArray = tcid.alias();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            if (id.equals(alias)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getGroupingId() {
        TaskChainMenuEntry entry = this.chain.getClass().getAnnotation(TaskChainMenuEntry.class);
        if (entry == null) {
            return "none";
        }
        return entry.groupingId();
    }

    @Override
    public boolean isDevelopment() {
        TaskChainMenuEntry entry = this.chain.getClass().getAnnotation(TaskChainMenuEntry.class);
        if (entry == null) {
            return true;
        }
        return entry.development();
    }

    @Override
    public boolean isVisibleInMenu() {
        return this.chain.getClass().getAnnotation(TaskChainMenuEntry.class) != null;
    }

    public String toString() {
        return this.getLabel();
    }
}

