/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.AbstractSourceEditorHandler;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class SourceEditorOperationHandler
extends AbstractSourceEditorHandler {
    private final int textOperation;

    public SourceEditorOperationHandler(int textOperation) {
        this.textOperation = textOperation;
    }

    public SourceEditorOperationHandler(SourceEditor editor, int textOperation) {
        super(editor);
        this.textOperation = textOperation;
    }

    protected final int getTextOperation() {
        return this.textOperation;
    }

    protected @Nullable ITextOperationTarget getOperationTarget(SourceEditor editor) {
        ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        if (target == null) {
            target = editor.getViewer().getTextOperationTarget();
        }
        return target;
    }

    @Override
    protected boolean isEditAction() {
        switch (this.textOperation) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean computeEnabled(SourceEditor editor, @Nullable Object evaluationContext) {
        if (super.computeEnabled(editor, evaluationContext)) {
            ITextOperationTarget operationTarget = this.getOperationTarget(editor);
            return operationTarget != null && operationTarget.canDoOperation(this.textOperation);
        }
        return false;
    }

    @Override
    protected @Nullable Object execute(SourceEditor editor, ExecutionEvent event) throws ExecutionException {
        ITextOperationTarget operationTarget = this.getOperationTarget(editor);
        if (operationTarget != null && operationTarget.canDoOperation(this.textOperation)) {
            operationTarget.doOperation(this.textOperation);
            return null;
        }
        Display.getCurrent().beep();
        return null;
    }
}

