/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status;

import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;

@NonNullByDefault
public class BasicProgressMonitor
implements ProgressMonitor {
    private static final int ROOT_FLAG = Integer.MIN_VALUE;
    private static final int INHERITED_FLAGS = 18;
    protected final ProgressData data;
    private final int flags;
    private String taskName;
    private final double progressDataDone;
    private int workRemaining;
    private double workProgressFactor;
    private final @Nullable BasicProgressMonitor parent;
    private @Nullable BasicProgressMonitor currentSub;

    private BasicProgressMonitor(ProgressData data, @Nullable BasicProgressMonitor parent, double progressDone, int flags) {
        this.data = data;
        this.parent = parent;
        this.flags = flags;
        this.taskName = data.mainTaskName;
        this.progressDataDone = progressDone;
    }

    public BasicProgressMonitor(ProgressData data, int flags) {
        this(data, null, 0.0, Integer.MIN_VALUE | flags);
    }

    @Override
    public void beginTask(String name, int totalWork) {
        if ((this.flags & 2) == 0 && name != null) {
            this.taskName = name;
            this.data.setMainTaskName(name);
        }
        this.setWorkRemaining(totalWork);
    }

    @Override
    public void beginSubTask(@Nullable String name) {
        this.checkProgress();
        this.data.setSubTaskName(name);
    }

    @Override
    public ProgressMonitor setWorkRemaining(int work) {
        this.checkProgress();
        if (work >= 0) {
            if ((this.flags & Integer.MIN_VALUE) != 0) {
                this.data.setProgressUnknown(false);
            }
            double progressRemaining = this.data.progress - this.progressDataDone;
            if (work == 0 || progressRemaining <= 0.0) {
                this.workProgressFactor = 0.0;
                this.workRemaining = 0;
                this.data.setProgress(this.progressDataDone);
            } else {
                this.workRemaining = work;
                this.workProgressFactor = progressRemaining / (double)work;
            }
        } else {
            if (work == -1 && (this.flags & Integer.MIN_VALUE) != 0) {
                this.data.setProgressUnknown(true);
            }
            this.workProgressFactor = 0.0;
        }
        return this;
    }

    @Override
    public void addWorked(int work) {
        this.checkProgress();
        this.data.setProgress(this.consumeWork(work));
    }

    @Override
    public @NonNull ProgressMonitor newSubMonitor(int work, int flags) {
        this.checkProgress();
        this.currentSub = new BasicProgressMonitor(this.data, this, this.consumeWork(work), this.flags & 0x12 | flags);
        return this.currentSub;
    }

    @Override
    public void done() {
        BasicProgressMonitor parent = this.parent;
        if (parent != null) {
            parent.checkProgress();
        } else {
            this.setWorkRemaining(0);
            this.data.setSubTaskName(null);
        }
    }

    private double consumeWork(int work) {
        if (work > 0 && this.workProgressFactor != 0.0) {
            this.workRemaining = Math.max(this.workRemaining - work, 0);
        }
        return this.progressDataDone + (double)this.workRemaining * this.workProgressFactor;
    }

    private void checkProgress() {
        BasicProgressMonitor currentSub = this.currentSub;
        if (currentSub != null) {
            this.currentSub = null;
            this.data.setMainTaskName(this.taskName);
            this.data.setProgress(currentSub.progressDataDone);
        }
    }

    @Override
    public boolean isCanceled() {
        return (this.flags & 0x10) == 0 && this.data.isCanceled();
    }

    @Override
    public void setCanceled(boolean state) {
        this.data.setCanceled(state);
    }

    @Override
    public void setBlocked(Status reason) {
        this.data.setBlocked(reason);
    }

    @Override
    public void clearBlocked() {
        this.data.clearBlocked();
    }

    public static class ProgressData {
        protected static final byte MAIN_TASK_NAME = 2;
        protected static final byte SUB_TASK_NAME = 4;
        protected static final byte PROGRESS_UNKNOWN = 8;
        protected static final byte PROGRESS_RATE = 16;
        protected static final byte CANCELED = 32;
        protected static final byte BLOCKED = 64;
        private String mainTaskName = "";
        private @Nullable String subTaskName;
        private boolean progressUnknown;
        private double progress = 1.0;
        private volatile boolean isCanceled;
        private @Nullable Status blocked;

        public String getMainTaskName() {
            return this.mainTaskName;
        }

        protected final void setMainTaskName(String name) {
            if (!Objects.equals(this.mainTaskName, name)) {
                this.mainTaskName = name;
                this.subTaskName = null;
                this.onDataChanged((byte)2);
            } else if (this.subTaskName != null) {
                this.subTaskName = null;
                this.onDataChanged((byte)4);
            }
        }

        public @Nullable String getSubTaskName() {
            return this.subTaskName;
        }

        private final void setSubTaskName(@Nullable String name) {
            if (name != null && name.isEmpty()) {
                name = null;
            }
            if (!Objects.equals(this.subTaskName, name)) {
                this.subTaskName = name;
                this.onDataChanged((byte)4);
            }
        }

        public boolean isProgressUnknown() {
            return this.progressUnknown;
        }

        private void setProgressUnknown(boolean enabled) {
            if (this.progressUnknown != enabled) {
                this.progressUnknown = enabled;
                this.onDataChanged((byte)8);
            }
        }

        public double getProgress() {
            return this.progress;
        }

        private void setProgress(double progress) {
            if (progress < this.progress) {
                this.progress = progress;
                this.onDataChanged((byte)16);
            }
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        protected void setCanceled(boolean state) {
            if (this.isCanceled != state) {
                this.isCanceled = state;
                this.onDataChanged((byte)32);
            }
        }

        public @Nullable Status getBlocked() {
            return this.blocked;
        }

        protected void setBlocked(Status reason) {
            if (!Objects.equals(this.blocked, reason)) {
                this.blocked = reason;
                this.onDataChanged((byte)64);
            }
        }

        protected void clearBlocked() {
            if (this.blocked != null) {
                this.blocked = null;
                this.onDataChanged((byte)64);
            }
        }

        protected void onDataChanged(byte data) {
        }
    }
}

