/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.XMLDataValue;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SqlXmlUtil {
    private DocumentBuilder dBuilder;
    private Transformer serializer;
    private XPathExpression query;
    private QName returnType;

    public SqlXmlUtil() throws StandardException {
        try {
            DocumentBuilderFactory documentBuilderFactory = null;
            try {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            catch (Throwable throwable) {
                throw StandardException.newException("XML00", "JAXP");
            }
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            this.dBuilder = documentBuilderFactory.newDocumentBuilder();
            this.dBuilder.setErrorHandler(new XMLErrorHandler());
            this.loadSerializer();
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.newException("XML01", throwable, throwable.getMessage());
        }
        this.query = null;
    }

    public void compileXQExpr(String string, String string2) throws StandardException {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(NullNamespaceContext.SINGLETON);
            this.query = xPath.compile(string);
        }
        catch (Throwable throwable) {
            throw StandardException.newException("10000", throwable, string2, throwable.getMessage());
        }
    }

    protected String serializeToString(String string) throws Exception {
        Document document;
        try {
            final InputSource inputSource = new InputSource(new StringReader(string));
            document = AccessController.doPrivileged(new PrivilegedExceptionAction<Document>(){

                @Override
                public Document run() throws IOException, SAXException {
                    return SqlXmlUtil.this.dBuilder.parse(inputSource);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
        return this.serializeToString(Collections.singletonList(document), null);
    }

    protected String serializeToString(List list, XMLDataValue xMLDataValue) throws TransformerException {
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1 && list.get(0) instanceof String) {
            return (String)list.get(0);
        }
        StringWriter stringWriter = new StringWriter();
        for (Object e : list) {
            if (e instanceof Attr) {
                xMLDataValue.markAsHavingTopLevelAttr();
                this.serializer.transform(new DOMSource((Node)e), new StreamResult(stringWriter));
                continue;
            }
            Node node = (Node)e;
            if (node instanceof Text) {
                stringWriter.write(node.getNodeValue());
                continue;
            }
            this.serializer.transform(new DOMSource(node), new StreamResult(stringWriter));
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    protected List evalXQExpression(XMLDataValue xMLDataValue, boolean bl, int[] nArray) throws Exception {
        List<Object> list;
        if (xMLDataValue.getXType() != 0) {
            throw StandardException.newException("2200V", bl ? "XMLQUERY" : "XMLEXISTS");
        }
        Document document = this.dBuilder.parse(new InputSource(new StringReader(xMLDataValue.getString())));
        Object object = this.evaluate(document);
        if (!bl) {
            if (object instanceof NodeList && ((NodeList)object).getLength() == 0) {
                return null;
            }
            return Collections.emptyList();
        }
        if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i));
            }
            list = arrayList;
        } else {
            list = Collections.singletonList(object);
        }
        nArray[0] = list.size() == 1 && list.get(0) instanceof Document ? 0 : 1;
        return list;
    }

    private Object evaluate(Document document) throws XPathExpressionException {
        if (this.returnType != null) {
            return this.query.evaluate(document, this.returnType);
        }
        try {
            Object object = this.query.evaluate(document, XPathConstants.NODESET);
            this.returnType = XPathConstants.NODESET;
            return object;
        }
        catch (Exception exception) {
            Object object = this.query.evaluate(document, XPathConstants.STRING);
            this.returnType = XPathConstants.STRING;
            return object;
        }
    }

    private void loadSerializer() throws TransformerConfigurationException {
        Properties properties = new Properties();
        properties.setProperty("method", "xml");
        properties.setProperty("omit-xml-declaration", "yes");
        properties.setProperty("encoding", "UTF-8");
        this.serializer = TransformerFactory.newInstance().newTransformer();
        this.serializer.setOutputProperties(properties);
    }

    private static class NullNamespaceContext
    implements NamespaceContext {
        private static final NullNamespaceContext SINGLETON = new NullNamespaceContext();

        private NullNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String string) {
            return "";
        }

        @Override
        public String getPrefix(String string) {
            return null;
        }

        public Iterator getPrefixes(String string) {
            return Collections.emptyList().iterator();
        }
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }
    }
}

