/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.eutils.autonature.Task;

public abstract class AutoConfig {
    private final String id;
    private final String enabledPrefKey;
    private final List<Task> tasks;

    public AutoConfig(String id, List<Task> tasks) {
        this.id = id;
        this.enabledPrefKey = String.valueOf(id) + ".enabled";
        this.tasks = tasks;
    }

    public String getId() {
        return this.id;
    }

    public String getEnabledPrefKey() {
        return this.enabledPrefKey;
    }

    public boolean isAvailable() {
        if (this.getLabel() == null) {
            return false;
        }
        for (Task task : this.tasks) {
            if (task.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public boolean isSupported(byte mode) {
        for (Task task : this.tasks) {
            if (task.isSupported(mode)) continue;
            return false;
        }
        return true;
    }

    public abstract String getLabel();

    public List<Task> getTasks() {
        return this.tasks;
    }

    public String toString() {
        return this.id;
    }

    static class Dummy
    extends AutoConfig {
        public Dummy(String id) {
            super(id, Collections.emptyList());
        }

        @Override
        public String getLabel() {
            return null;
        }
    }
}

