/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.text.PairMatcher;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.yaml.core.source.YamlBracketPairMatcher;
import org.eclipse.statet.yaml.core.source.YamlHeuristicTokenScanner;

public class YamlDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    private final YamlHeuristicTokenScanner scanner;
    private final PairMatcher pairMatcher;

    public YamlDoubleClickStrategy(YamlHeuristicTokenScanner scanner) {
        this.scanner = scanner;
        this.pairMatcher = new YamlBracketPairMatcher(this.scanner);
    }

    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        try {
            IRegion region;
            TreePartition partition = (TreePartition)TextUtilities.getPartition((IDocument)document, (String)this.scanner.getDocumentPartitioning(), (int)offset, (boolean)true);
            String type = partition.getType();
            if (type == "Yaml.Default" && (region = this.pairMatcher.match(document, offset)) != null && region.getLength() >= 2) {
                textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
                return;
            }
            partition = (TreePartition)TextUtilities.getPartition((IDocument)document, (String)this.scanner.getDocumentPartitioning(), (int)offset, (boolean)false);
            type = partition.getType();
            TreePartitionNode treeNode = partition.getTreeNode();
            switch (type) {
                case "Yaml.Key": 
                case "Yaml.Tag": 
                case "Yaml.Value": {
                    if (offset != treeNode.getStartOffset()) break;
                    textViewer.setSelectedRange(treeNode.getStartOffset(), treeNode.getLength());
                    return;
                }
                case "Yaml.Comment": {
                    if (offset != treeNode.getStartOffset() && offset != treeNode.getStartOffset() + 1) break;
                    textViewer.setSelectedRange(treeNode.getStartOffset(), treeNode.getLength());
                    return;
                }
            }
            super.doubleClicked(textViewer);
            return;
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        textViewer.setSelectedRange(offset, 0);
    }
}

