/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.eutils.autonature.core.ProjectConfigurator;
import org.eclipse.statet.r.core.RBuildpaths;
import org.eclipse.statet.r.core.RProjects;
import org.eclipse.ui.statushandlers.StatusManager;

public class RPkgProjectConfigurator
implements org.eclipse.ui.wizards.datatransfer.ProjectConfigurator,
ProjectConfigurator {
    private static final Path PKG_DESCRIPTION_FILE_JPATH = Paths.get("DESCRIPTION", new String[0]);
    private static final Path PKG_NAMESPACE_FILE_JPATH = Paths.get("NAMESPACE", new String[0]);
    private static final Path E_PROJECT_FILE_JPATH = Paths.get(".project", new String[0]);
    private static final Path E_METADATA_DIR_JPATH = Paths.get(".metadata", new String[0]);
    private static final int MAX_DEPTH = 3;

    private static boolean isFileExists(IContainer parent, IPath path) {
        IResource member = parent.findMember(path);
        return member != null && member.getType() == 1 && member.exists();
    }

    private static boolean isFileExists(Path parent, Path path) {
        return Files.isRegularFile(parent.resolve(path), new LinkOption[0]);
    }

    private static boolean isRPkgRoot(IContainer container) {
        return RPkgProjectConfigurator.isFileExists(container, RBuildpaths.PKG_DESCRIPTION_FILE_PATH) && RPkgProjectConfigurator.isFileExists(container, RBuildpaths.PKG_NAMESPACE_FILE_PATH);
    }

    private static boolean isRPkgRoot(Path container) {
        return RPkgProjectConfigurator.isFileExists(container, PKG_DESCRIPTION_FILE_JPATH) && RPkgProjectConfigurator.isFileExists(container, PKG_NAMESPACE_FILE_JPATH);
    }

    private static void addExistingFolder(IContainer parent, IPath path, Set<IFolder> set) {
        IResource member = parent.findMember(path);
        if (member != null && member.getType() == 2) {
            set.add((IFolder)member);
        }
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        Path rootPath = root.toPath();
        RPkgRootsJFinder finder = new RPkgRootsJFinder(rootPath, monitor);
        try {
            finder.visit(rootPath);
        }
        catch (OperationCanceledException e) {
            return null;
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, NLS.bind((String)"An error occurred when searching for R packages in ''{0}''.", (Object)root.getAbsolutePath()), (Throwable)e));
        }
        return finder.getPkgRoots();
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        RPkgRootResourceFinder finder = this.searchPkgRoot(container, null, monitor);
        return finder != null && finder.hasPkgRootInLimit();
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        HashSet<IFolder> toIgnore = new HashSet<IFolder>();
        RPkgProjectConfigurator.addExistingFolder((IContainer)project, RBuildpaths.PKG_R_FOLDER_PATH, toIgnore);
        RPkgProjectConfigurator.addExistingFolder((IContainer)project, RBuildpaths.PKG_DATA_FOLDER_PATH, toIgnore);
        RPkgProjectConfigurator.addExistingFolder((IContainer)project, RBuildpaths.PKG_DEMO_FOLDER_PATH, toIgnore);
        RPkgProjectConfigurator.addExistingFolder((IContainer)project, RBuildpaths.PKG_MAN_FOLDER_PATH, toIgnore);
        RPkgProjectConfigurator.addExistingFolder((IContainer)project, RBuildpaths.PKG_PO_FOLDER_PATH, toIgnore);
        RPkgProjectConfigurator.addExistingFolder((IContainer)project, RBuildpaths.PKG_INST_FOLDER_PATH, toIgnore);
        RPkgProjectConfigurator.addExistingFolder((IContainer)project, RBuildpaths.PKG_RCHECK_FOLDER_PATH, toIgnore);
        return toIgnore;
    }

    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        RPkgRootResourceFinder finder;
        try {
            if (project.hasNature("org.eclipse.statet.r.resourceProjects.RPkg")) {
                return false;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return (finder = this.searchPkgRoot((IContainer)project, ignoredPaths, monitor)) != null && finder.hasPkgRoot();
    }

    public byte check(IProject project, IProgressMonitor monitor) {
        RPkgRootResourceFinder finder = this.searchPkgRoot((IContainer)project, null, monitor);
        return (byte)(finder != null && finder.hasPkgRoot() ? 2 : 0);
    }

    public void configure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        block3: {
            IContainer pkgRoot;
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
            RPkgRootResourceFinder rootFinder = this.searchPkgRoot((IContainer)project, ignoredPaths, (IProgressMonitor)m.newChild(1));
            if (rootFinder == null || (pkgRoot = rootFinder.getPkgRoot()) == null) {
                return;
            }
            try {
                RProjects.setupRPkgProject((IProject)project, (IPath)pkgRoot.getProjectRelativePath(), (IProgressMonitor)m.newChild(3));
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() == 8) break block3;
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, NLS.bind((String)"An error occurred when configuring R project ''{0}''.", (Object)project.getFullPath().toString()), (Throwable)e));
            }
        }
    }

    public void configure(IProject project, IProgressMonitor monitor) {
        this.configure(project, null, monitor);
    }

    private RPkgRootResourceFinder searchPkgRoot(IContainer container, Set<IPath> ignoredPaths, IProgressMonitor m) {
        RPkgRootResourceFinder finder = new RPkgRootResourceFinder(container, ignoredPaths, m);
        try {
            container.accept((IResourceVisitor)finder);
        }
        catch (AbortException abortException) {
        }
        catch (OperationCanceledException e) {
            return null;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, NLS.bind((String)"An error occurred when searching for R packages in ''{0}''.", (Object)container.getFullPath().toString()), (Throwable)e));
            return null;
        }
        return finder;
    }

    private static class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    private static class RPkgRootResourceFinder
    implements IResourceVisitor {
        private final IContainer root;
        private final Set<IPath> ignoredPaths;
        private IContainer pkgRoot;
        private final IProgressMonitor monitor;

        public RPkgRootResourceFinder(IContainer root, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
            this.root = root;
            this.ignoredPaths = ignoredPaths;
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            switch (resource.getType()) {
                case 2: 
                case 4: {
                    if (!this.monitor.isCanceled()) break;
                    throw new OperationCanceledException();
                }
                default: {
                    return false;
                }
            }
            if (resource != this.root && this.ignoredPaths != null) {
                for (IPath ignoredDirectory : this.ignoredPaths) {
                    if (!ignoredDirectory.equals((Object)resource.getLocation())) continue;
                    return false;
                }
            }
            if (RPkgProjectConfigurator.isRPkgRoot((IContainer)resource)) {
                if (this.pkgRoot != null) {
                    this.pkgRoot = null;
                    throw new AbortException();
                }
                this.pkgRoot = (IContainer)resource;
                return false;
            }
            return true;
        }

        public boolean hasPkgRoot() {
            return this.pkgRoot != null;
        }

        public boolean hasPkgRootInLimit() {
            int depth = 0;
            IContainer folder = this.pkgRoot;
            while (folder != null && depth <= 3) {
                if (folder.equals((Object)this.root)) {
                    return true;
                }
                folder = folder.getParent();
                ++depth;
            }
            return false;
        }

        public IContainer getPkgRoot() {
            return this.pkgRoot;
        }
    }

    private static class RPkgRootsJFinder {
        private static final int ROOT = 10000;
        private final Path root;
        private List<File> pkgRoots;
        private int lastPkgRootDepth;
        private final IProgressMonitor monitor;

        public RPkgRootsJFinder(Path root, IProgressMonitor monitor) {
            this.root = root;
            this.monitor = monitor;
        }

        public int visit(Path dir) throws IOException {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (dir != this.root && RPkgProjectConfigurator.isFileExists(dir, E_PROJECT_FILE_JPATH)) {
                return 10000;
            }
            if (RPkgProjectConfigurator.isRPkgRoot(dir)) {
                if (this.pkgRoots == null) {
                    this.pkgRoots = new ArrayList<File>();
                }
                this.pkgRoots.add(dir.toFile());
                this.lastPkgRootDepth = 0;
                return 1;
            }
            int count = 0;
            Throwable throwable = null;
            Object var4_5 = null;
            try (DirectoryStream<Path> subDirs = Files.newDirectoryStream(dir, path -> Files.isDirectory(path, new LinkOption[0]));){
                for (Path subDir : subDirs) {
                    if (subDir.endsWith(E_METADATA_DIR_JPATH)) {
                        count += 10000;
                        continue;
                    }
                    count += this.visit(subDir);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (count == 1 && this.lastPkgRootDepth < 3) {
                this.pkgRoots.set(this.pkgRoots.size() - 1, dir.toFile());
                ++this.lastPkgRootDepth;
            }
            return count;
        }

        public Set<File> getPkgRoots() {
            return this.pkgRoots != null ? new HashSet<File>(this.pkgRoots) : null;
        }
    }
}

