/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateCompletionComputer;
import org.eclipse.statet.ltk.ui.templates.SourceEditorTemplateContext;
import org.eclipse.statet.r.ui.editors.templates.REditorContext;
import org.eclipse.text.templates.ContextTypeRegistry;

@NonNullByDefault
public class REditorTemplateCompletionComputer
extends TemplateCompletionComputer {
    public REditorTemplateCompletionComputer() {
        super((TemplateStore)RUIPlugin.getInstance().getREditorTemplateStore(), (ContextTypeRegistry)RUIPlugin.getInstance().getREditorTemplateContextRegistry());
    }

    protected @Nullable String extractPrefix(AssistInvocationContext context) {
        try {
            IDocument document = context.getSourceViewer().getDocument();
            int end = context.getInvocationOffset();
            int start = Math.max(end - 50, 0);
            String text = document.get(start, end - start);
            for (int i = text.length() - 1; i >= 0; --i) {
                char c = text.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '.' || c == '_') {
                    continue;
                }
                if (c == '\\' || c == '@') {
                    return text.substring(i);
                }
                return text.substring(i + 1);
            }
            return "";
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    protected @Nullable TemplateContextType getContextType(AssistInvocationContext context, TextRegion region) {
        try {
            ISourceEditor editor = context.getEditor();
            AbstractDocument document = (AbstractDocument)context.getSourceViewer().getDocument();
            ITypedRegion partition = document.getPartition(editor.getDocumentContentInfo().getPartitioning(), region.getStartOffset(), true);
            if (partition.getType() == "R.Roxygen") {
                return this.getTypeRegistry().getContextType("roxygen");
            }
            return this.getTypeRegistry().getContextType("r-code");
        }
        catch (BadLocationException | BadPartitioningException throwable) {
            return null;
        }
    }

    protected @Nullable SourceEditorTemplateContext createTemplateContext(AssistInvocationContext context, TextRegion region, int flags) {
        TemplateContextType contextType = this.getContextType(context, region);
        if (contextType != null) {
            return new REditorContext(contextType, context.getDocument(), region, context.getEditor(), flags);
        }
        return null;
    }
}

