/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.actions;

import java.util.List;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ts.ui.ToolRunnableDecorator;
import org.eclipse.statet.internal.rtm.base.ui.actions.Messages;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.r.core.tool.AbstractStatetRRunnable;
import org.eclipse.statet.r.core.tool.IRConsoleService;
import org.eclipse.statet.r.ui.pkgmanager.RPkgManagerUI;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.runtime.RPkgManager;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.statet.rtm.base.ui.RTaskSnippet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

public class RTaskRunnable
extends AbstractStatetRRunnable
implements ToolRunnableDecorator {
    private static final int PACKAGE_CHECK = 1;
    private final RTaskSnippet snippet;
    private final IWorkbenchPage page;
    private int state;

    protected static String createTypeId(RTaskSnippet snippet) {
        return "r/rtask/" + snippet.getDescriptor().getTaskId();
    }

    protected static String createLabel(RTaskSnippet snippet) {
        return snippet.getDescriptor().getName();
    }

    public RTaskRunnable(RTaskSnippet snippet, IWorkbenchPage page) {
        this(RTaskRunnable.createTypeId(snippet), snippet.getLabel(), snippet, page);
    }

    public RTaskRunnable(String typeId, String label, RTaskSnippet snippet, IWorkbenchPage page) {
        super(typeId, label);
        this.snippet = snippet;
        this.page = page;
    }

    public Image getImage() {
        return this.snippet.getDescriptor().getImage();
    }

    protected void run(IRConsoleService r, ProgressMonitor m) throws StatusException {
        RTaskRunnable.checkNewCommand((IRConsoleService)r, (ProgressMonitor)m);
        if (!this.checkPackages(r, m)) {
            return;
        }
        r.briefAboutToChange();
        try {
            r.submitToConsole(this.snippet.getRCode(), m);
        }
        finally {
            r.briefChanged(1);
        }
    }

    protected boolean checkPackages(IRConsoleService r, ProgressMonitor m) throws StatusException {
        final RTool tool = r.getTool();
        REnv rEnv = tool.getREnv();
        if (rEnv == null) {
            return true;
        }
        IRPkgManager rPkgMgr = RCore.getRPkgManager((REnv)rEnv);
        if (rPkgMgr == null) {
            return true;
        }
        List<String> requiredPkgs = this.snippet.getRequiredPkgs();
        if (RPkgUtils.areInstalled((RPkgManager)rPkgMgr, requiredPkgs, (RService)r, (ProgressMonitor)m)) {
            return true;
        }
        if (this.state == 1) {
            return false;
        }
        this.state = 1;
        return RPkgManagerUI.requestRequiredRPkgs((IRPkgManager.Ext)((IRPkgManager.Ext)rPkgMgr), requiredPkgs, (RToolService)r, (ProgressMonitor)m, (IShellProvider)this.page.getWorkbenchWindow(), (String)NLS.bind((String)Messages.RunTask_RequirePkgs_message, (Object)this.snippet.getDescriptor().getName()), (Runnable)new Runnable(){

            @Override
            public void run() {
                tool.getQueue().add((ToolRunnable)RTaskRunnable.this);
            }
        }, null);
    }
}

