/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.preferences;

import java.util.HashMap;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.statet.ecommons.databinding.core.validation.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.text.ui.settings.IndentSettingsUI;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.preferences.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RCodeStylePreferenceBlock
extends ManagedConfigurationBlock {
    private RCodeStyleSettings model;
    private IndentSettingsUI stdIndentSettings;
    private Text indentBlockDepth;
    private Text indentGroupDepth;
    private Text indentWrappedCommandDepth;
    private ImList<Operator> operators;
    private Button nlFDefBodyBlockBefore;

    public RCodeStylePreferenceBlock(IProject project, StatusChangeListener statusListener) {
        super(project, statusListener);
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Object, String> prefs = new HashMap<Object, String>();
        prefs.put(RCodeStyleSettings.INDENT_DEFAULT_TYPE_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.TAB_SIZE_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.INDENT_SPACES_COUNT_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.REPLACE_TABS_WITH_SPACES_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.REPLACE_CONVERSATIVE_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.INDENT_BLOCK_DEPTH_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.INDENT_GROUP_DEPTH_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.INDENT_WRAPPED_COMMAND_DEPTH_PREF, "r/r.codestyle/indent");
        this.operators = ImCollections.newList((Object[])new Operator[]{new Operator(Messages.RCodeStyle_Whitespace_Assign_label, "whitespaceAssignBefore", (Preference<Boolean>)RCodeStyleSettings.WS_ASSIGN_BEFORE_PREF, "whitespaceAssignAfter", (Preference<Boolean>)RCodeStyleSettings.WS_ASSIGN_AFTER_PREF), new Operator(Messages.RCodeStyle_Whitespace_ArgAssign_label, "whitespaceArgAssignBefore", (Preference<Boolean>)RCodeStyleSettings.WS_ARGASSIGN_BEFORE_PREF, "whitespaceArgAssignAfter", (Preference<Boolean>)RCodeStyleSettings.WS_ARGASSIGN_AFTER_PREF), new Operator(Messages.RCodeStyle_Whitespace_OtherOp_label, "whitespaceOtherOpBefore", (Preference<Boolean>)RCodeStyleSettings.WS_OTHEROP_BEFORE_PREF, "whitespaceOtherOpAfter", (Preference<Boolean>)RCodeStyleSettings.WS_OTHEROP_AFTER_PREF)});
        for (Operator operator : this.operators) {
            prefs.put(operator.wsBeforePref, "r/r.codestyle/ws");
            prefs.put(operator.wsAfterPref, "r/r.codestyle/ws");
        }
        prefs.put(RCodeStyleSettings.NL_FDEF_BODYBLOCK_BEFORE_PREF, "r/r.codestyle/ws");
        this.setupPreferenceManager(prefs);
        this.model = new RCodeStyleSettings(0);
        this.stdIndentSettings = new IndentSettingsUI();
        Composite mainComposite = new Composite(pageComposite, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        TabFolder folder = new TabFolder(mainComposite, 0);
        folder.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        TabItem item = new TabItem(folder, 0);
        item.setText(this.stdIndentSettings.getGroupLabel());
        item.setControl(this.createIndentControls((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("&More");
        item.setControl(this.createMoreControls((Composite)folder));
        this.initBindings();
        this.updateControls();
    }

    private Control createIndentControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)2));
        this.stdIndentSettings.createControls(composite);
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        Composite depthComposite = new Composite(composite, 0);
        depthComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        depthComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
        this.indentBlockDepth = this.createIndentDepthLine(depthComposite, Messages.RCodeStyle_Indent_IndentInBlocks_label);
        this.indentGroupDepth = this.createIndentDepthLine(depthComposite, Messages.RCodeStyle_Indent_IndentInGroups_label);
        this.indentWrappedCommandDepth = this.createIndentDepthLine(depthComposite, Messages.RCodeStyle_Indent_IndentOfWrappedCommands_label);
        return composite;
    }

    private Text createIndentDepthLine(Composite composite, String label) {
        Label labelControl = new Label(composite, 16384);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text textControl = new Text(composite, 133124);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)textControl, (int)2);
        textControl.setLayoutData((Object)gd);
        Label typeControl = new Label(composite, 16384);
        typeControl.setText(this.stdIndentSettings.getLevelUnitLabel());
        typeControl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        return textControl;
    }

    private Control createMoreControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)4));
        Label label = new Label(composite, 16384);
        label.setText(Messages.RCodeStyle_Whitespace_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = new Label(composite, 0);
        label.setText(Messages.RCodeStyle_Whitespace_Before_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = new Label(composite, 0);
        label.setText(Messages.RCodeStyle_Whitespace_After_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label dummy = new Label(composite, 0);
        dummy.setVisible(false);
        dummy.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 4));
        for (Operator operator : this.operators) {
            Label label2 = new Label(composite, 0);
            label2.setText(String.valueOf(operator.label) + "\u200a:");
            GridData gd = new GridData(4, 0x1000000, false, false);
            gd.horizontalIndent = LayoutUtils.defaultIndent();
            label2.setLayoutData((Object)gd);
            operator.wsBeforeControl = new Button(composite, 32);
            operator.wsBeforeControl.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            operator.wsAfterControl = new Button(composite, 32);
            operator.wsAfterControl.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        }
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        this.nlFDefBodyBlockBefore = new Button(composite, 32);
        this.nlFDefBodyBlockBefore.setText(Messages.RCodeStyle_Newline_FDefBodyBlock_Before_label);
        this.nlFDefBodyBlockBefore.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        this.stdIndentSettings.addBindings(db, (Object)this.model);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indentBlockDepth), BeanProperties.value(RCodeStyleSettings.class, (String)"indentBlockDepth", Integer.TYPE).observe(db.getRealm(), (Object)this.model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 10, Messages.RCodeStyle_Indent_IndentInBlocks_error_message)), null);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indentGroupDepth), BeanProperties.value(RCodeStyleSettings.class, (String)"indentGroupDepth", Integer.TYPE).observe(db.getRealm(), (Object)this.model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 10, Messages.RCodeStyle_Indent_IndentInGroups_error_message)), null);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indentWrappedCommandDepth), BeanProperties.value(RCodeStyleSettings.class, (String)"indentWrappedCommandDepth", Integer.TYPE).observe(db.getRealm(), (Object)this.model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 10, Messages.RCodeStyle_Indent_IndentOfWrappedCommands_error_message)), null);
        for (Operator operator : this.operators) {
            db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)operator.wsBeforeControl), BeanProperties.value(RCodeStyleSettings.class, (String)operator.wsBeforeProp, Boolean.TYPE).observe(db.getRealm(), (Object)this.model));
            db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)operator.wsAfterControl), BeanProperties.value(RCodeStyleSettings.class, (String)operator.wsAfterProp, Boolean.TYPE).observe(db.getRealm(), (Object)this.model));
        }
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.nlFDefBodyBlockBefore), BeanProperties.value(RCodeStyleSettings.class, (String)"newlineFDefBodyBlockBefore", Boolean.TYPE).observe(db.getRealm(), (Object)this.model));
    }

    protected void updateControls() {
        this.model.load((PreferenceAccess)this);
        this.model.resetDirty();
        this.getDataBinding().getContext().updateTargets();
    }

    protected void updatePreferences() {
        if (this.model.isDirty()) {
            this.model.resetDirty();
            this.setPrefValues(this.model.toPreferencesMap());
        }
    }

    private static class Operator {
        private final String label;
        private final String wsBeforeProp;
        private final Preference<Boolean> wsBeforePref;
        private final String wsAfterProp;
        private final Preference<Boolean> wsAfterPref;
        private Button wsBeforeControl;
        private Button wsAfterControl;

        public Operator(String label, String wsBeforeProp, Preference<Boolean> wsBeforePref, String wsAfterProp, Preference<Boolean> wsAfterPref) {
            this.label = label;
            this.wsBeforeProp = wsBeforeProp;
            this.wsBeforePref = wsBeforePref;
            this.wsAfterProp = wsAfterProp;
            this.wsAfterPref = wsAfterPref;
        }
    }
}

