/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.ToolRegistry;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusManager;

class PageRegistry
implements IDebugEventSetListener,
IDebugContextListener {
    static final String SHOW_CONSOLE_JOB_NAME = "Show NIConsole";
    private final IWorkbenchPage fPage;
    private boolean fClosed;
    private IDebugContextListener fDebugContextListener;
    private ToolProcess fActiveProcess;
    private NIConsole fActiveConsole;
    final FastList<WorkbenchToolRegistryListener> fListeners;
    private final ShowConsoleViewJob fShowConsoleViewJob = new ShowConsoleViewJob(100);
    private final OnConsoleChangedJob fConsoleUpdateJob = new OnConsoleChangedJob();
    private final OnToolTerminatedJob fTerminatedJob = new OnToolTerminatedJob();

    PageRegistry(IWorkbenchPage page, WorkbenchToolRegistryListener[] initial) {
        this.fPage = page;
        this.fListeners = new FastList(WorkbenchToolRegistryListener.class, 1, (Object[])initial);
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public synchronized void dispose() {
        this.fClosed = true;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        this.fShowConsoleViewJob.cancel();
        this.fConsoleUpdateJob.cancel();
        this.fTerminatedJob.cancel();
        this.fListeners.clear();
        this.fActiveProcess = null;
        this.fActiveConsole = null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        IStructuredSelection sel;
        ISelection selection = event.getContext();
        if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1) {
            IProcess process;
            Object element = sel.getFirstElement();
            ToolProcess tool = null;
            if (element instanceof IAdaptable && (process = (IProcess)((IAdaptable)element).getAdapter(IProcess.class)) instanceof ToolProcess) {
                tool = (ToolProcess)process;
            }
            if (tool == null && element instanceof ILaunch) {
                IProcess[] processes = ((ILaunch)element).getProcesses();
                int i = 0;
                while (i < processes.length) {
                    if (processes[i] instanceof ToolProcess) {
                        tool = (ToolProcess)processes[i];
                        break;
                    }
                    ++i;
                }
            }
            if (tool != null) {
                this.showConsole(NicoUITools.getConsole(tool), false);
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        ToolProcess tool = this.fActiveProcess;
        if (tool == null) {
            return;
        }
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource() == tool && event.getKind() == 8) {
                this.fTerminatedJob.scheduleTerminated(tool);
            }
            ++n2;
        }
    }

    public IWorkbenchPage getPage() {
        return this.fPage;
    }

    public synchronized ToolProcess getActiveProcess() {
        return this.fActiveProcess;
    }

    public synchronized WorkbenchToolSessionData createSessionInfo(IViewPart source) {
        return new WorkbenchToolSessionData((Tool)this.fActiveProcess, (Object)this.fActiveConsole, this.fPage, null);
    }

    public IConsoleView getConsoleView(NIConsole console) {
        if (this.fClosed) {
            return null;
        }
        return this.searchView(console);
    }

    void handleConsolesRemoved(List<ToolProcess> tools) {
        this.fConsoleUpdateJob.scheduleRemoved(tools);
    }

    void handleActiveConsoleChanged(NIConsole console, IViewPart source) {
        this.fConsoleUpdateJob.scheduleActivated(console, source);
    }

    void showConsole(NIConsole console, boolean activate) {
        this.fShowConsoleViewJob.schedule(console, activate);
    }

    void showConsoleExplicitly(NIConsole console, final boolean pin) {
        this.fShowConsoleViewJob.cancel();
        new ShowConsoleViewJob(this, 0){

            @Override
            protected void finish(IConsoleView view) {
                if (pin) {
                    view.setPinned(true);
                }
            }
        }.schedule(console, true);
    }

    private void notifyActiveToolSessionChanged(IViewPart source) {
        Object[] listeners;
        WorkbenchToolSessionData sessionData = new WorkbenchToolSessionData((Tool)this.fActiveProcess, (Object)this.fActiveConsole, this.fPage, source);
        if (ToolRegistry.DEBUG) {
            System.out.println("[tool registry] tool session activated: " + sessionData.toString());
        }
        Object[] objectArray = listeners = this.fListeners.toArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            try {
                ((WorkbenchToolRegistryListener)obj).toolSessionActivated(sessionData);
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, "An error occurred when handling tool activation.", (Throwable)e));
            }
            ++n2;
        }
    }

    private void notifyToolTerminated() {
        Object[] listeners;
        WorkbenchToolSessionData sessionData = new WorkbenchToolSessionData((Tool)this.fActiveProcess, (Object)this.fActiveConsole, this.fPage, null);
        if (ToolRegistry.DEBUG) {
            System.out.println("[tool registry] activate tool terminated: " + sessionData.toString());
        }
        Object[] objectArray = listeners = this.fListeners.toArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            try {
                ((WorkbenchToolRegistryListener)obj).toolTerminated(sessionData);
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, "An error occurred when handling tool termination.", (Throwable)e));
            }
            ++n2;
        }
    }

    private List<IConsoleView> getConsoleViews() {
        IViewReference[] allReferences;
        ArrayList<IConsoleView> consoleViews = new ArrayList<IConsoleView>();
        IViewReference[] iViewReferenceArray = allReferences = this.fPage.getViewReferences();
        int n = allReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart view;
            IViewReference reference = iViewReferenceArray[n2];
            if (reference.getId().equals("org.eclipse.ui.console.ConsoleView") && (view = reference.getView(true)) != null) {
                IConsoleView consoleView = (IConsoleView)view;
                if (!consoleView.isPinned()) {
                    consoleViews.add(consoleView);
                } else if (consoleView.getConsole() instanceof NIConsole) {
                    consoleViews.add(0, consoleView);
                }
            }
            ++n2;
        }
        return consoleViews;
    }

    private NIConsole searchConsole(List<ToolProcess> exclude) {
        IConsole console;
        NIConsole nico = null;
        IWorkbenchPart part = this.fPage.getActivePart();
        if (part instanceof IConsoleView && (console = ((IConsoleView)part).getConsole()) instanceof NIConsole && !exclude.contains((nico = (NIConsole)console).getProcess())) {
            return nico;
        }
        List<IConsoleView> consoleViews = this.getConsoleViews();
        NIConsole secondChoice = null;
        for (IConsoleView view : consoleViews) {
            IConsole console2 = view.getConsole();
            if (!(console2 instanceof NIConsole) || exclude.contains((nico = (NIConsole)console2).getProcess())) continue;
            if (this.fPage.isPartVisible((IWorkbenchPart)view)) {
                return nico;
            }
            if (secondChoice != null) continue;
            secondChoice = nico;
        }
        return secondChoice;
    }

    private IConsoleView searchView(NIConsole console) {
        List<IConsoleView> views = this.getConsoleViews();
        IConsoleView[] preferedView = new IConsoleView[10];
        for (IConsoleView view : views) {
            IConsole consoleInView = view.getConsole();
            if (consoleInView == console) {
                if (this.fPage.isPartVisible((IWorkbenchPart)view)) {
                    preferedView[view.isPinned() ? 0 : 1] = view;
                    continue;
                }
                preferedView[view.isPinned() ? 2 : 3] = view;
                continue;
            }
            if (consoleInView == null) {
                if (this.fPage.isPartVisible((IWorkbenchPart)view)) {
                    preferedView[4] = view;
                    continue;
                }
                preferedView[5] = view;
                continue;
            }
            if (view.isPinned()) continue;
            String secId = view.getViewSite().getSecondaryId();
            if (secId != null && secId.startsWith(console.getType())) {
                preferedView[6] = view;
                continue;
            }
            if (this.fPage.isPartVisible((IWorkbenchPart)view)) {
                preferedView[7] = view;
                continue;
            }
            preferedView[8] = view;
        }
        int i = 0;
        while (i < preferedView.length) {
            if (preferedView[i] != null) {
                return preferedView[i];
            }
            ++i;
        }
        return null;
    }

    private class OnConsoleChangedJob
    extends Job
    implements ISchedulingRule {
        private volatile NIConsole fConsole;
        private volatile IViewPart fSource;
        private volatile List<ToolProcess> fExclude;

        public OnConsoleChangedJob() {
            super("NicoUI Registry - On Console Changed");
            this.setSystem(true);
            this.setPriority(20);
        }

        public boolean belongsTo(Object family) {
            return family == PageRegistry.this;
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof Job) {
                return ((Job)rule).belongsTo((Object)PageRegistry.this);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleActivated(NIConsole console, IViewPart source) {
            PageRegistry pageRegistry = PageRegistry.this;
            synchronized (pageRegistry) {
                if (this.fExclude != null && console != null && this.fExclude.contains(console.getProcess())) {
                    return;
                }
                this.cancel();
                this.fConsole = console;
                this.fSource = source;
                this.schedule(50L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleRemoved(List<ToolProcess> exclude) {
            PageRegistry pageRegistry = PageRegistry.this;
            synchronized (pageRegistry) {
                if (this.fConsole != null && exclude.contains(this.fConsole.getProcess())) {
                    this.fConsole = null;
                } else if (PageRegistry.this.fActiveProcess == null && !exclude.contains(PageRegistry.this.fActiveProcess)) {
                    return;
                }
                this.cancel();
                this.fExclude = exclude;
                this.schedule(200L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (PageRegistry.this.fClosed) {
                return Status.OK_STATUS;
            }
            NIConsole console = this.fConsole;
            final List<ToolProcess> exclude = this.fExclude;
            if (console == null) {
                final AtomicReference ref = new AtomicReference();
                UIAccess.getDisplay((Shell)PageRegistry.this.fPage.getWorkbenchWindow().getShell()).syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ref.set(PageRegistry.this.searchConsole(exclude != null ? exclude : Collections.emptyList()));
                    }
                });
                console = (NIConsole)((Object)ref.get());
            }
            PageRegistry pageRegistry = PageRegistry.this;
            synchronized (pageRegistry) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.fConsole == console) {
                    this.fConsole = null;
                    this.fExclude = null;
                }
                if (console == PageRegistry.this.fActiveConsole || console == null && PageRegistry.this.fActiveConsole == null) {
                    return Status.OK_STATUS;
                }
                PageRegistry.this.fActiveProcess = console != null ? console.getProcess() : null;
                PageRegistry.this.fActiveConsole = console;
            }
            PageRegistry.this.notifyActiveToolSessionChanged(this.fSource);
            return Status.OK_STATUS;
        }
    }

    private class OnToolTerminatedJob
    extends Job
    implements ISchedulingRule {
        private volatile ToolProcess fTool;

        public OnToolTerminatedJob() {
            super("NicoUI Registry - On Tool Terminated");
            this.setSystem(true);
            this.setPriority(20);
        }

        public boolean belongsTo(Object family) {
            return family == PageRegistry.this;
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof Job) {
                return ((Job)rule).belongsTo((Object)PageRegistry.this);
            }
            return false;
        }

        public void scheduleTerminated(ToolProcess tool) {
            this.fTool = tool;
            this.schedule(0L);
        }

        public synchronized IStatus run(IProgressMonitor monitor) {
            ToolProcess tool = this.fTool;
            this.fTool = null;
            if (PageRegistry.this.getActiveProcess() == tool) {
                PageRegistry.this.notifyToolTerminated();
            }
            return Status.OK_STATUS;
        }
    }

    private class ShowConsoleViewJob
    extends WorkbenchJob {
        private final int fDelay;
        private volatile NIConsole fConsoleToShow;
        private volatile boolean fActivate;

        public ShowConsoleViewJob(int delay) {
            super(PageRegistry.SHOW_CONSOLE_JOB_NAME);
            this.setSystem(true);
            this.setPriority(20);
            this.fDelay = delay;
        }

        public void schedule(NIConsole console, boolean activate) {
            this.cancel();
            this.fConsoleToShow = console;
            this.fActivate = activate;
            this.schedule(this.fDelay);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            NIConsole console = this.fConsoleToShow;
            if (PageRegistry.this.fClosed || console == null) {
                return Status.CANCEL_STATUS;
            }
            try {
                IWorkbenchPart activePart = PageRegistry.this.fPage.getActivePart();
                if (activePart instanceof IConsoleView && console == ((IConsoleView)activePart).getConsole()) {
                    ((IConsoleView)activePart).setFocus();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                IConsoleView view = PageRegistry.this.searchView(console);
                IStatus iStatus = this.showInView(view, monitor);
                return iStatus;
            }
            catch (PartInitException e) {
                NicoUIPlugin.logError(100, "Error of unexpected type occured, when showing a console view.", e);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                this.fConsoleToShow = null;
            }
        }

        private IStatus showInView(IConsoleView view, IProgressMonitor monitor) throws PartInitException {
            NIConsole console = this.fConsoleToShow;
            boolean activate = this.fActivate;
            if (PageRegistry.this.fClosed || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (view == null) {
                String secId = String.valueOf(console.getType()) + System.currentTimeMillis();
                view = (IConsoleView)PageRegistry.this.fPage.showView("org.eclipse.ui.console.ConsoleView", secId, 3);
            }
            view.display((IConsole)console);
            if (activate) {
                PageRegistry.this.fPage.activate((IWorkbenchPart)view);
            } else {
                PageRegistry.this.fPage.bringToTop((IWorkbenchPart)view);
            }
            this.finish(view);
            return Status.OK_STATUS;
        }

        protected void finish(IConsoleView view) {
        }
    }
}

