/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpath.ui;

import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ltk.buildpath.ui.BuildpathListElement;
import org.eclipse.statet.ltk.buildpath.ui.BuildpathListElementAttribute;

public class BuildpathListElementComparator
extends ViewerComparator {
    protected static final int SOURCE = 0;
    protected static final int PROJECT = 1;
    protected static final int LIBRARY = 2;
    protected static final int VARIABLE = 3;
    protected static final int CONTAINER = 4;
    protected static final int ATTRIBUTE = 11;
    protected static final int CONTAINER_ENTRY = 12;
    protected static final int OTHER = 100;

    public int category(Object obj) {
        if (obj instanceof BuildpathListElement) {
            BuildpathListElement element = (BuildpathListElement)obj;
            if (element.getParent() != null) {
                return 12;
            }
            return this.getCategory(element);
        }
        if (obj instanceof BuildpathListElementAttribute) {
            return 11;
        }
        return 100;
    }

    protected int getCategory(BuildpathListElement element) {
        String typeName = element.getType().getName();
        if (typeName == "Source") {
            return 0;
        }
        if (typeName == "Project") {
            return 1;
        }
        if (typeName == "Library") {
            return 2;
        }
        if (typeName == "Variable") {
            return 3;
        }
        return 100;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        IBaseLabelProvider prov;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (cat1 == 11 || cat1 == 12) {
            return 0;
        }
        if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            ILabelProvider lprov = (ILabelProvider)prov;
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            return this.getComparator().compare(name1, name2);
        }
        return 0;
    }
}

