/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rtool;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.models.core.util.ElementPartition;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.util.ViewActionUtil;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

@NonNullByDefault
public class CopyRElementHandler
extends AbstractHandler {
    private final ViewActionUtil actionUtil;
    private final ILabelProvider labelProvider;

    public CopyRElementHandler(ViewActionUtil actionUtil, ILabelProvider labelProvider) {
        this.actionUtil = actionUtil;
        this.labelProvider = labelProvider;
    }

    private IStructuredSelection getSelection() {
        ISelectionProvider selectionProvider = this.actionUtil.getSelectionProvider();
        return (IStructuredSelection)selectionProvider.getSelection();
    }

    protected boolean isValidSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        for (Object element : selection.toList()) {
            if (!(element instanceof ElementPartition)) continue;
            return false;
        }
        return true;
    }

    private @Nullable String getText(Object element) {
        return this.labelProvider.getText(element);
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        this.setBaseEnabled(this.isValidSelection(this.getSelection()));
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        if (!UIAccess.isOkToUse((Control)this.actionUtil.getControl())) {
            return null;
        }
        IStructuredSelection selection = this.getSelection();
        if (!this.isValidSelection(selection)) {
            return null;
        }
        String text = this.createData(selection);
        if (text != null) {
            this.copy(text);
        }
        return null;
    }

    protected @Nullable String createData(IStructuredSelection selection) {
        ArrayList<String> texts = new ArrayList<String>(selection.size());
        for (Object element : selection.toList()) {
            texts.add((String)ObjectUtils.nonNullElse((Object)this.getText(element), (Object)"-"));
        }
        return texts.size() == 1 ? (String)texts.get(0) : CollectionUtils.toString(texts, (String)", ");
    }

    private void copy(String text) {
        DNDUtils.setContent((Clipboard)this.actionUtil.getClipboard(), (Object[])new String[]{text}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
    }
}

