/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.r;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.source.doc.RDocumentSetupParticipant;
import org.eclipse.statet.r.ui.editors.REditorBuild;

@NonNullByDefault
public class RDocumentProvider
extends SourceDocumentProvider<RSourceUnit>
implements Disposable {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SettingsChangeNotifier.ChangeListener editorPrefListener;
    private boolean handleTemporaryProblems;

    public RDocumentProvider() {
        super("R", (PartitionerDocumentSetupParticipant)new RDocumentSetupParticipant(), REditorBuild.R_ISSUE_TYPE_SET);
        SettingsChangeNotifier.ChangeListener editorPrefListener;
        this.editorPrefListener = editorPrefListener = new SettingsChangeNotifier.ChangeListener(){

            public void settingsChanged(Set<String> groupIds) {
                if (groupIds.contains("r/r.editor/build.options")) {
                    RDocumentProvider.this.updateEditorPrefs();
                }
            }
        };
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(editorPrefListener);
        PreferenceAccess access = EPreferences.getInstancePrefs();
        this.handleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        SettingsChangeNotifier.ChangeListener editorPrefListener = this.editorPrefListener;
        if (editorPrefListener != null) {
            this.editorPrefListener = null;
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(editorPrefListener);
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = EPreferences.getInstancePrefs();
        boolean newHandleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.handleTemporaryProblems != newHandleTemporaryProblems) {
            this.handleTemporaryProblems = newHandleTemporaryProblems;
            RModel.getRModelManager().refresh(Ltk.EDITOR_CONTEXT);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource, RDocumentProvider.this.getIssueTypeSet());
        }

        protected boolean isHandlingTemporaryProblems(IssueTypeSet.ProblemCategory issueCategory) {
            return RDocumentProvider.this.handleTemporaryProblems;
        }
    }
}

