/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.eutils.autonature.wizards.ConfigureProjectWizard;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.IWorkbenchPart;

@NonNullByDefault
public class ConfigureProjectHandler
extends AbstractHandler {
    private @Nullable IProject getProject(Object element) {
        if (element instanceof IProject) {
            return (IProject)element;
        }
        if (element instanceof IAdaptable) {
            return (IProject)((IAdaptable)element).getAdapter(IProject.class);
        }
        return null;
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project;
        IStructuredSelection structuredSelection;
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (project = this.getProject(structuredSelection.getFirstElement())) != null) {
            IWorkbenchPart activePart = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
            ConfigureProjectWizard wizard = new ConfigureProjectWizard(project);
            WizardDialog dialog = new WizardDialog(activePart != null ? activePart.getSite().getShell() : UIAccess.getActiveWorkbenchShell((boolean)true), (IWizard)wizard);
            dialog.open();
        }
        return null;
    }
}

